/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.connectors.mailconnector.api;

import javax.mail.*;
import javax.mail.Message.*;
import javax.mail.internet.*;
import javax.resource.*;

/**
 * Application-level connection handle that is used by a 
 * client component to access an EIS instance.
 * 
 * @author Alejandro E. Murillo
 */

public interface JavaMailConnection
{
    /**
     * Fetches new messages from the mail server. Application-specific method. 
     *
     * @return an array of messages
     */

    public javax.mail.Message[] getNewMessages()
        throws ResourceException;

    /**
     * Fetches new message headers from the mail server. Application-specific 
     * method. 
     *
     * @return a String array of message headers
     */

    public String[] getNewMessageHeaders()
        throws ResourceException;

    /**
     * Closes the connection.
     */
    public void close() 
	throws ResourceException;
}
