/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * @(#)MailServerFolder.java	
 */

package samples.connectors.mailconnector.ra.outbound;

import javax.mail.*;
import javax.mail.internet.*;

import java.util.*;
import java.util.logging.*;
import java.net.*;
import java.io.*;
import java.rmi.*;
import java.rmi.registry.*;
import java.rmi.server.*;
import javax.rmi.*;
import javax.naming.*;

import samples.connectors.mailconnector.ra.*;
import samples.connectors.mailconnector.ra.inbound.*;
//import samples.connectors.mailconnector.ra.outbound.*;
import samples.connectors.mailconnector.share.*;



/**
 * @author Alejandro Murillo
 *
 */

public class MailServerStore
{
    private javax.mail.Session 		session;
    private javax.mail.Authenticator 	authenticator;
    private javax.mail.Store 		store;
    private Properties 			mailProperties;

    private String 			userName, password, 
                  			serverName, protocol;

    public static final Logger logger   = 
        Logger.getLogger("samples.connectors.mailconnector.ra.outbound");

    /**
     * Constructor.
     *
     * @param spec the ConnectionSpec (ConnectionRequestInfo)
     */
    public MailServerStore(ConnectionSpecImpl spec)
	throws Exception
    {
	userName    = spec.getUserName();
	password    = spec.getPassword();
	serverName  = spec.getServerName();
	protocol    = spec.getProtocol();

        this.authenticator = null;

	mailProperties = new Properties();
	mailProperties.setProperty("mail.transport.protocol", "smtp");
	mailProperties.setProperty("mail.store.protocol", protocol);
	mailProperties.setProperty("mail.smtp.host", serverName);
        
        connectStore();
    }	

    /**
     * Closes the Store.
     *
     * @exception Exception if the close fails
     */

    public void closeStore()  
	throws Exception 
    {
         /*
          * The JavaMail Session object does not have an explicit close.  
          */

	 //logger.info("Listener::close()");
         this.store.close();
         this.store = null;
         this.authenticator = null;
         this.session = null;
    }

    /** 
     * Opens a connection to the mail server. Associated with a MC
     *
     * @exception Exception  if the open fails
     */

    private void connectStore() 
	throws Exception 
    {
	try
	{
	    // Get a session object
	    session = javax.mail.Session.getDefaultInstance(mailProperties);
	    // Get a store object
	    store = session.getStore();
            this.store.connect(serverName, userName, password);
        } catch (Exception te) {
            logger.info("[S] Caught an exception when obtaining a " +
                "JavaMail Session");
	    throw new Exception(te.getMessage());
        }

        
    }
        
    public  javax.mail.Folder getFolder(String folderName) 
	throws Exception 
    {
        javax.mail.Folder 		folder;
        folder = this.store.getFolder(folderName);

        if ((folder == null) || (! folder.exists())) 
	{
            Exception e = new Exception("Folder " + folderName +
                " does not exist or is not found");
            throw e;
        }
        
        
        return folder;
    }
    
    /**
     * Retrieves new messages. Used by a JavaMailConnection
     *
     * @return an array of messages
     */

    

    public Message[] getNewMessages(javax.mail.Folder folder)
	throws Exception
    {
        if ((folder == null) || (! folder.exists())) 
	{
            Exception e = new Exception("Folder " + folder +
                " does not exist or is not found");
            throw e;
        }
        
        if ( !folder.isOpen() ) 
	{
            folder.open(javax.mail.Folder.READ_WRITE);
        }
        
        //
        // Deliver only new messages to the MDB
        //

	try 
	{
	    int newMsgs = folder.getNewMessageCount();
	    if (newMsgs > 0)
	    {
	      	int msgCount   = folder.getMessageCount();
	      	Message msgs[] = 
	      	    folder.getMessages(msgCount - newMsgs + 1, msgCount);
	        return msgs;
	    }
        } catch (Exception e) { 
	    logger.info("[S] Exception obtaining messages from mail server");
	}
	return null;
    }

    /**
     * Retrieves headers of new messages.
     *
     * @return a string array containing the message headers
     */

    public String[] getNewMessageHeaders(javax.mail.Folder folder)
	throws Exception
    {
        if ((folder == null) || (! folder.exists())) 
	{
            Exception e = new Exception("Folder " + folder +
                " does not exist or is not found");
            throw e;
        }
        
        if ( !folder.isOpen() ) 
	{
            folder.open(javax.mail.Folder.READ_WRITE);
        }
        //
        // Deliver only new messages to the MDB
        //

	try 
	{
	    int newMsgs = folder.getNewMessageCount();

	    if (newMsgs > 0)
	    {
	        int msgCount   = folder.getMessageCount();
	      	Message[] msgs = 
	      	    folder.getMessages(msgCount - newMsgs + 1, msgCount);   
	        String[] headers = new String[msgs.length];
		logger.info("messages length: " + msgs.length);
		logger.info("headers length: " + headers.length);
	        for (int i = 0; i < headers.length; i++)
	        {
		    logger.info("<MSF> Packing message with SUBJECT: " +
		        msgs[i].getSubject());
		    headers[i] = msgs[i].getSubject();
	        }
	        return headers;
	    }
        } catch (Exception e) { 
	    logger.severe("[S] Exception obtaining messages from mail server:");
            e.printStackTrace(); 
	}
	return null;
    }
    
    public boolean isTheSameStore(ConnectionRequestInfoImpl cxRequestInfo)
    {      
        if ( !userName.equals(cxRequestInfo.getUserName()) )
            return false;
        if ( !password.equals(cxRequestInfo.getPassword()) )
            return false;
        if ( !serverName.equals(cxRequestInfo.getServerName()) )
            return false;
        if ( !protocol.equals(cxRequestInfo.getProtocol()) )
            return false;
        
        logger.info("isTheSameStore: found match!");
        return true;
    }
}
