/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.connectors.mailconnector.ra.inbound;

import javax.resource.NotSupportedException;
import javax.resource.spi.*;
import javax.resource.spi.endpoint.*;
import javax.resource.spi.work.*;
import javax.resource.*;

import java.rmi.*;
import javax.rmi.*;
import java.rmi.server.*;
import java.util.ArrayList;
import java.util.logging.*;
import java.security.*;
import java.lang.reflect.*;

import javax.mail.*;
import javax.mail.Message.*;
import javax.mail.internet.*;

//import samples.connectors.mailconnector.ra.*;
import samples.connectors.mailconnector.api.*;
//import samples.connectors.mailconnector.backend.*;

import com.sun.mail.imap.*;

/**
 * JavaMail Client RMI interface.
 * 
 * This is a singleton class that represents the Client interface
 * used by the JavaMail Service.
 * 
 * @author Alejandro Murillo
 */

public class EndpointConsumer
{
    ActivationSpecImpl      activationSpec;
    MessageEndpointFactory  endpointFactory;
    MailServerFolder        folder  = null;
        
        
    static Logger logger = 
        Logger.getLogger("samples.connectors.mailconnector.ra.inbound",
        	    "samples.connectors.mailconnector.ra.inbound.LocalStrings"); 

    public Method onMessage = null;

    /**
     * Constructor. Creates a JavaMail Client Interface object and exports it 
     * so that the server can access it.
     *
     * @param endpointFactory a MessageEndpointFactory
     * @param activationSpec  the activation spec
     */

    public EndpointConsumer(MessageEndpointFactory endpointFactory,
				ActivationSpecImpl activationSpec)
	throws Exception 
    {
	this.endpointFactory = endpointFactory;
	this.activationSpec  = activationSpec;
	try
	{
            folder = new MailServerFolder(activationSpec);  
	} catch(AuthenticationFailedException ie) {
	    logger.info("[EC] Authentication problem when opening Mail Folder: " + 
			getUniqueKey() + 
			" Wrong password?, fix ejb-jar.xml, rebuild and redeploy");
	    //ie.printStackTrace();
	    throw ie;
	} catch(Exception ie) {
	    logger.info("[EC] Unexpected Error while opening Mail Folder: " + 
			getUniqueKey() + 
			" check for typos with foldername, username, password or hostname in ejb-jar.xml, rebuild and redeploy");
	    //ie.printStackTrace();
	    throw ie;
	}
        logger.info("[EC] Created EndpointConsumer for: " + getUniqueKey());
    }

    public void deliverMessages()
	throws RemoteException
    {
         try 
	 {
	      	Message msgs[] = folder.getNewMessages();
	        if (msgs != null)
	        {
	            for (int i = 0; i < msgs.length; i++)
	      	    {
	                if ( !msgs[i].isSet(Flags.Flag.SEEN) ) //Deliver only once
                        {
                            deliverMessage(msgs[i]);
		            // Mark message as seen
		            msgs[i].setFlag(Flags.Flag.SEEN, true);
                        }
	            }
	        }
	 } catch(Exception ie) {
		logger.info("[EC] deliverMessages caught an exception. Bailing out");
		ie.printStackTrace();
	 }
    }
    
    /**
     * Delivers it to the appropriate EndPoint.
     *
     * @param message  the message to be delivered
     */

    private void deliverMessage(javax.mail.Message message)
	throws RemoteException
    {
        MessageEndpoint endpoint = null;

        Object[] args = { message };
        
        try
        {
           // o Create endpoint, passing XAResource.
           // o Call beforeDelivery to allow the appserver
	   //   to engage delivery in transaction, if required.
           // o Deliver Message.
           
           if ( (endpoint = endpointFactory.createEndpoint(null)) != null)
	   {
	       // If this was an XA capable RA then invoke 
	       //  endpoint.beforeDelivery();
               ((samples.connectors.mailconnector.api.JavaMailMessageListener) 
                   endpoint).onMessage(message);
	   }
        } catch(Exception e) {
            logger.log(Level.WARNING, "messagereceiver.onmessageexception", 
                e.getMessage());
        } catch(Error error) {
            logger.log(Level.WARNING, "messagereceiver.onmessageexception", 
                error.getMessage());
        } catch(Throwable t) {
            logger.log(Level.WARNING, "messagereceiver.onmessageexception", 
                t.getMessage());
        } finally {
            // o Call afterDelivery to to permit the Application Server to 
            //   complete or rollback transaction on  delivery. This should 
            //   occur even if an exception has been thrown.
            // o Call release to indicate the endpoint can be recycled.
            
            if (endpoint != null)
            {
	        //If this was an XA capable RA then invoke 
	        //  endpoint.afterDelivery();
                endpoint.release();
            }
        }
    }
    
    public boolean hasNewMessages()
	throws Exception
    {
        //logger.info("[EC] Checking for new messages on: " + getUniqueKey());
	return  folder.hasNewMessages();
    }

    public String getUniqueKey()
    {
        return  activationSpec.getUserName() + "::" +
		activationSpec.getFolderName() + "@" + 
		activationSpec.getServerName();
    }  
}
