/* Copyright 2004 Sun Microsystems, Inc.  All rights reserved.  You may not modify, use, reproduce, or distribute this software except in compliance with the terms of the License at: 
 http://adventurebuilder.dev.java.net/LICENSE.txt
 $Id: CreditCardVerifier.java,v 1.4 2004/05/26 00:06:48 inder Exp $ */

package com.sun.j2ee.blueprints.opc.financial;

import javax.naming.*;
import javax.xml.rpc.*;
import java.rmi.*;

import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;
import com.sun.j2ee.blueprints.opc.JNDINames;

/**
 * This component verifies a credit card
 * with the bank's credit card service
 */
public class CreditCardVerifier { 
    
    private CreditCardIntf port;
  
    public CreditCardVerifier () {
    try{
        Context ic = new InitialContext();
  CreditCardService ccSvc = (CreditCardService) ic.lookup(JNDINames.CREDIT_CARD_SERVICE_NAME);
        String endpointURI = (String) ic.lookup(JNDINames.CREDIT_CARD_SERVICE_URL);
      port = (CreditCardIntf) ccSvc.getPort(CreditCardIntf.class);
        ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY, endpointURI);   
    } catch (Exception exe){
        System.err.println(exe);    
    }
    }
    
    public boolean verifyCreditCard(String cc) throws RemoteException { 
        boolean stat = false; 
  stat = port.validateCreditCard(cc);
        return stat;
    }
}
