/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.webservices.security.web.xms;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.util.Enumeration;
import java.security.KeyStoreException;

public class pkcs12Tojks {
    public static void main(String args[]) throws Throwable {
        
        if (args.length<5) {
            System.out.println(
            "Usage: pkcs12Tojks  pkcs12file pkcs12file_password jksfile jksfile_password config_dir");
            System.exit(0);
        }
        
        FileInputStream inFile;
        inFile = new FileInputStream(args[0]);
        KeyStore inputKeyStore = KeyStore.getInstance("PKCS12");
        char[] pkcsPwd = args[1].toCharArray();
        if (pkcsPwd.length==0) {
            pkcsPwd = null;
        }
        inputKeyStore.load(inFile,pkcsPwd);
        inFile.close();
        
        // create keystores (for keystore.jks and cacerts.jks)
        KeyStore outPutKeyStore = KeyStore.getInstance("JKS");
        KeyStore outPutTrustStore = KeyStore.getInstance("JKS");
        char[] jksPwd = args[3].toCharArray();
        if (jksPwd.length==0) {
            jksPwd = null;
        }
        outPutKeyStore.load(null,jksPwd);
        outPutTrustStore.load(null,jksPwd);
        
        // Now load keys from input keystore(PKCS12) to output keystores(JKS)
        Enumeration en = inputKeyStore.aliases();
        while (en.hasMoreElements()) {
            String alias = (String) en.nextElement();
            if (inputKeyStore.isCertificateEntry(alias)) {
                System.out.println("importing certificate " + alias);
                outPutKeyStore.setCertificateEntry(alias,
                               inputKeyStore.getCertificate(alias));
                outPutTrustStore.setCertificateEntry(alias,
                               inputKeyStore.getCertificate(alias));
            }
            
            if (inputKeyStore.isKeyEntry(alias)) {
                System.out.println("importing key " + alias);
                outPutKeyStore.setKeyEntry(alias,
                               inputKeyStore.getKey(alias,pkcsPwd),
                jksPwd,inputKeyStore.getCertificateChain(alias));
                outPutTrustStore.setCertificateEntry(alias,
                               inputKeyStore.getCertificate(alias));
            }
        }
        
        // create output file for keystore.jks
        FileOutputStream out = new FileOutputStream(args[4]+"/"+args[2]);
        outPutKeyStore.store(out,jksPwd);
        out.close();
        System.out.println("Created JavaKeystore "+args[2]);
        
        // create output file for cacerts.jks
        FileOutputStream out2 = new FileOutputStream(args[4]+"/"+"cacerts.jks");
        outPutTrustStore.store(out2,jksPwd);
        out2.close();
        System.out.println("Created JavatrustStore cacerts.jks");
        System.exit(0);
    }
}
