/*
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials
 *   provided with the distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
 * DAMAGES OR LIABILITIES SUFFERED BY LICENSEE AS A RESULT OF OR
 * RELATING TO USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE OR
 * ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT,
 * SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF
 * THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 */

package samples.webservices.security.ejb.basicAuth;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.util.Enumeration;
import java.security.KeyStoreException;

public class pkcs12Tojks {
    public static void main(String args[]) throws Throwable {
        
        if (args.length<5) {
            System.out.println(
            "Usage: pkcs12Tojks  pkcs12file pkcs12file_password jksfile jksfile_password config_dir");
            System.exit(0);
        }
        
        FileInputStream inFile;
        inFile = new FileInputStream(args[0]);
        KeyStore inputKeyStore = KeyStore.getInstance("PKCS12");
        char[] pkcsPwd = args[1].toCharArray();
        if (pkcsPwd.length==0) {
            pkcsPwd = null;
        }
        inputKeyStore.load(inFile,pkcsPwd);
        inFile.close();
        
        // create keystores (for keystore.jks and cacerts.jks)
        KeyStore outPutKeyStore = KeyStore.getInstance("JKS");
        KeyStore outPutTrustStore = KeyStore.getInstance("JKS");
        char[] jksPwd = args[3].toCharArray();
        if (jksPwd.length==0) {
            jksPwd = null;
        }
        outPutKeyStore.load(null,jksPwd);
        outPutTrustStore.load(null,jksPwd);
        
        // Now load keys from input keystore(PKCS12) to output keystores(JKS)
        Enumeration en = inputKeyStore.aliases();
        while (en.hasMoreElements()) {
            String alias = (String) en.nextElement();
            if (inputKeyStore.isCertificateEntry(alias)) {
                System.out.println("importing certificate " + alias);
                outPutKeyStore.setCertificateEntry(alias,
                               inputKeyStore.getCertificate(alias));
                outPutTrustStore.setCertificateEntry(alias,
                               inputKeyStore.getCertificate(alias));
            }
            
            if (inputKeyStore.isKeyEntry(alias)) {
                System.out.println("importing key " + alias);
                outPutKeyStore.setKeyEntry(alias,
                               inputKeyStore.getKey(alias,pkcsPwd),
                jksPwd,inputKeyStore.getCertificateChain(alias));
                outPutTrustStore.setCertificateEntry(alias,
                               inputKeyStore.getCertificate(alias));
            }
        }
        
        // create output file for keystore.jks
        FileOutputStream out = new FileOutputStream(args[4]+"/"+args[2]);
        outPutKeyStore.store(out,jksPwd);
        out.close();
        System.out.println("Created JavaKeystore "+args[2]);
        
        // create output file for cacerts.jks
        FileOutputStream out2 = new FileOutputStream(args[4]+"/"+"cacerts.jks");
        outPutTrustStore.store(out2,jksPwd);
        out2.close();
        System.out.println("Created JavatrustStore cacerts.jks");
        System.exit(0);
    }
}
