/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package samples.webservices.jaxrpc.simplebean;

import javax.xml.rpc.Service;
import javax.naming.*;

import java.math.BigDecimal;

public class HelloAppClient {

  public static void main(String[] args) {

    try {
      InitialContext ctx = new InitialContext();
      Service svc = (Service)ctx.lookup("java:comp/env/service/HelloWorld");
      HelloIF helloPort = (HelloIF)svc.getPort(samples.webservices.jaxrpc.simplebean.HelloIF.class);
      demoArray(helloPort);
      demoBean(helloPort);
    } catch (Exception ex) {
      ex.printStackTrace();
      System.exit(1);
    }

} // main   

private static void demoArray(HelloIF stub) {

  try {
    String[] words = {"it", "was", "a", "dark", "and",
		      "stormy", "night"};

    System.out.println("demoArray method:");
    for (int j = 0; j < words.length; j++) {
      System.out.print(words[j] + " ");
    }
    System.out.println();

    String[] backwards = stub.reverse(words);

    for (int j = 0; j < backwards.length; j++) {
      System.out.print(backwards[j] + " ");
    }
    System.out.println();

  } catch (Exception ex) {
    ex.printStackTrace();
  }
} // demoArray

private static void demoBean(HelloIF stub) {

  try {
    System.out.println();
    System.out.println("demoBean method:");
    SimpleAccountBean dukesAccount = new SimpleAccountBean();
    dukesAccount.setBalance(new BigDecimal("1200.00"));
    dukesAccount.setCustomerName("Duke");
    BigDecimal newBalance = stub.calculateInterest(dukesAccount);
    System.out.println("newBalance: " + newBalance);
    dukesAccount.setBalance(newBalance);
  } catch (Exception ex) {
    ex.printStackTrace();
  }
} // demoBean

} // class
