/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package jaxrpcmejb;

import javax.management.MBeanInfo;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.NotificationListener;
import javax.management.NotificationFilter;

import java.util.Set;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

import javax.naming.*;

import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.namespace.QName;

import java.rmi.RemoteException;
import javax.xml.rpc.Stub;

import com.sun.enterprise.management.agent.ws.*;

public class ManagementWSTransiever implements ManagementWSTransieverIF {
    
    private Hashtable ops = new Hashtable();
    private String targetEndpointAddress;
    private ManagementWSIF mws; // used by standalone client;
    private Hashtable listeners = new Hashtable();
    
    private HttpListener httpListener;
    
    public ManagementWSTransiever( String endpointAddress )
    throws NamingException, ServiceException {
        targetEndpointAddress = endpointAddress;
        System.out.println("Endpoint address = " + targetEndpointAddress);
        
        
 /*       Context ic = new InitialContext();
  
        try {
            System.out.println("looking up java:comp/env");
            NamingEnumeration ne = ic.list("java:comp/env");
            while (ne.hasMore()) {
                NameClassPair n  = (NameClassPair)ne.next();
                System.out.println(n.getName());
            }
        } catch (Exception e) {
            System.out.println(e);
        }
  
  
        Service genericServiceWithWSDL = (Service)
            ic.lookup("java:comp/env/service/ManagementWSServiceGenericWithWSDL");
        //Service genericServiceWithWSDL = (Service)
         //   ic.lookup("service/ManagementWSServiceGenericWithWSDL");
  
        QName mejbPortName = new QName("urn:Foo", "ManagementWSPort");
        Call[] mejbCalls = genericServiceWithWSDL.getCalls(mejbPortName);
        System.out.println("mejbCalls = " + mejbCalls);
  
        for(int i = 0; i < mejbCalls.length; i++) {
            mejbCalls[i].setTargetEndpointAddress(targetEndpointAddress);
            ops.put(((Object)mejbCalls[i].getOperationName().getLocalPart()),mejbCalls[i]);
        }
  */
        Stub stub = createProxy();
        stub._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY,
        targetEndpointAddress);
        
        mws = (ManagementWSIF) stub;
        
        // A HttpDaemon to listen for Notifications, Port number is 0 to
        // let the system pick up an unused port
        httpListener = new HttpListener( 0 );
        
    }
    
    private Stub createProxy() {
        // Note: MyHelloService_Impl is implementation-specific.
        return (Stub) (new ManagementWS_Impl().getManagementWSIFPort());
    }
    
    public Set queryNames( ObjectName name, QueryExp exp ) throws RemoteException {
        //System.out.println("queryNames: using QueryExp -> " + exp);
        String expString = null;
        if( exp != null) {
            expString = exp.toString();
        }
        //Object [] params = new Object [] {name.toString(),expString};
        //Set objectNameStringSet = (Set)
        //        ((Call)ops.get("queryNames")).invoke(params);
        Set objectNameStringSet = mws.queryNames(name.toString(),expString);
        Iterator it = objectNameStringSet.iterator();
        HashSet objectNameSet = new HashSet();
        while (it.hasNext()) {
            try {
                ObjectName on = new ObjectName((String)it.next());
                objectNameSet.add(on);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objectNameSet;
    }
    
    public boolean isRegistered(ObjectName name) throws RemoteException {
        //Object [] params = new Object [] {name.toString()};
        //Boolean registered = (Boolean)
        //        ((Call)ops.get("isRegistered")).invoke(params);
        return mws.isRegistered(name.toString());
    }
    
    public Integer getMBeanCount() throws RemoteException {
        //Object [] params = new Object [] {};
        //return (Integer)((Call)ops.get("getMBeanCount")).invoke(params);
        return mws.getMBeanCount();
    }
    
    public MBeanInfo getMBeanInfo(ObjectName name) throws RemoteException {
        //Object [] params = new Object [] {name.toString()};
        //String stringifiedMBeanInfo = (String)
        //        ((Call)ops.get("getMBeanInfo")).invoke(params);
        String stringifiedMBeanInfo = mws.getMBeanInfo(name.toString());
        //System.out.println("\n" + stringifiedMBeanInfo + "\n");
        return MBeanInfoSerializer.unmarshal(stringifiedMBeanInfo);
    }
    
    public Object getAttribute( ObjectName name, String attribute ) throws RemoteException {
        //Object [] params = new Object [] {name.toString(), attribute};
        //return ((Call)ops.get("getAttribute")).invoke(params);
        return mws.getAttribute(name.toString(), attribute);
    }
    
    public AttributeList getAttributes( ObjectName name, String[] attributes ) throws RemoteException {
        HashSet attributeSet = new HashSet();
        for( int i=0; i<attributes.length; i++) {
            attributeSet.add(attributes[i]);
        }
        //Object [] params = new Object [] {name.toString(), attributeSet};
        //String stringifiedAttributeList = (String)
        //        ((Call)ops.get("getAttributes")).invoke(params);
        String stringifiedAttributeList = mws.getAttributes(name.toString(), attributeSet);
        //System.out.println("\n" + stringifiedAttributeList + "\n");
        return AttributeListSerializer.unmarshal(stringifiedAttributeList);
    }
    
    public void setAttribute(ObjectName name, Attribute attribute) throws RemoteException {
        //Object [] params = new Object [] {name.toString(), attribute};
        //((Call)ops.get("setAttribute")).invoke(params);
        mws.setAttribute(name.toString(), attribute.getName(), attribute.getValue().toString());
    }
    
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws RemoteException {
        String stringifiedAttributeList = AttributeListSerializer.marshal(attributes);
        //Object [] params = new Object [] {name.toString(), stringifiedAttributeList};
        //return AttributeListSerializer.unmarshal((String)((Call)ops.get("setAttributes")).invoke(params));
        return AttributeListSerializer.unmarshal(mws.setAttributes(name.toString(), stringifiedAttributeList));
    }
    
    public Object invoke(
    ObjectName name, String operationName, Object[] parms, String[] sig)throws RemoteException {
        Set parameters = new HashSet();
        Set signature = new HashSet();
        for(int i=0; i<parms.length; i++) {
            parameters.add(parms[i]);
        }
        for(int i=0; i<sig.length; i++) {
            signature.add(sig[i]);
        }
        //Object [] params = new Object [] {name.toString(), operationName, parameters, signature};
        //return ((Call)ops.get("invoke")).invoke(params);
        return mws.invoke(name.toString(), operationName, parameters, signature);
    }
    
    
    public String getDefaultDomain() throws RemoteException {
        //Object [] params = new Object [] {};
        //return (String)((Call)ops.get("getDefaultDomain")).invoke(params);
        return mws.getDefaultDomain();
    }
    
    
    public javax.management.j2ee.ListenerRegistration getListenerRegistry() throws RemoteException {
        return new HttpListenerRegistry();
    }
    
    class HttpListenerRegistry implements javax.management.j2ee.ListenerRegistration {
        
        public void addNotificationListener( ObjectName objectName,
        NotificationListener listener, NotificationFilter filter, Object handbackValue ) {
            //*** TO DO Stringify NotificationFilter
            try {
                httpListener.add( listener );
                //Object [] params = new Object [] { objectName.toString(),
                //    httpListener.getUri() + "/" + String.valueOf(listener.hashCode()),
                //    filter,
                //    handbackValue };
                //((Call)ops.get( "addNotificationListener" )).invoke( params );
                String listenerId = httpListener.getUri() + "/" + String.valueOf(listener.hashCode());               
                mws.addNotificationListener( objectName.toString(), listenerId, null, (String)handbackValue );
                listeners.put(listener, listenerId);
            } catch ( Exception e ) {
                System.err.println( e );
                e.printStackTrace( );
            }
        }
        
        public void removeNotificationListener(ObjectName objectName, NotificationListener listener) {
            String listenerId = (String)listeners.get(listener);
            try {
                mws.removeNotificationListener(objectName.toString(), listenerId);
            } catch ( Exception e ) {
                System.err.println( e );
                e.printStackTrace( );
            }
            
        }
        
    }
    
}
