/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package jaxrpcmejb;

import java.net.*;
import java.io.*;
import java.util.Hashtable;
import org.exolab.castor.xml.Unmarshaller;
import javax.management.NotificationListener;
import com.sun.enterprise.management.agent.ws.LocalNotificationObject;

/**
 * This is a special HttpListener that listens to JSR 77 events only.
 * It accepts HTTP POST requests that contains serialized Notification
 * Objects and unmarshals using Castor'a Unmaprshaller library.
 */
public class HttpListener implements Runnable {

    private static final String HTTP_OK_RESPONSE= 
        "HTTP/1.1 200 OK\r\n\r\n";

    private static final int CONTENT_LENGTH_SIZE = 16; 

    private ServerSocket sSocket = null;

    private Hashtable clientListenerRegistry;

    private String uri;


    /**
     * The constructor accepts either '0' or any fixed port number. If a
     * '0' is passed for the port then it uses an unused port on the client.
     *
     * It is recommended to use '0' 
     */
    public HttpListener( int port ) {
        try {
            clientListenerRegistry = new Hashtable( );
            sSocket = new ServerSocket( port );
            uri = 
                "http://" + InetAddress.getLocalHost().getHostName() + ":" 
                + sSocket.getLocalPort( );
            System.out.println( "ListenerURI = " + uri );
            (new Thread(this)).start( );
        } catch ( Exception e ) {
            System.err.println( "Exception " + e );
            e.printStackTrace( );
        }
    }


    /**
     * A simple Daemon, that uses separate thread to process each HTTP Message.
     */
    public void run() {
        try {
			//System.out.println("before accept");
			//System.out.flush();
            Socket socket = sSocket.accept();
			//System.out.println("after accept");
			//System.out.flush(); 

            (new Thread(this)).start( );

            BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream()) );
			//System.out.println("BufferedReader <init> succeeded");
			//System.out.flush(); 
                        
            //System.out.println("Notify: " +  notify(in) );
			//System.out.flush();
            notify(in);
 
            PrintStream out = new PrintStream(
                                 new BufferedOutputStream(
                                    socket.getOutputStream() ));


            /* send the header */
            // For now we are sending the OK response without validating
            // This is to avoid blocking the thread.
            out.print( HTTP_OK_RESPONSE );
            out.flush();

            socket.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * This notifies the the Listener object after unmarshalling the
     * Stringified XML Notification Object,
     */
    private boolean notify(BufferedReader in) throws IOException
    {
        StringBuffer xmlMessage = new StringBuffer("");
        // Read the first line in the Header, it will be of the format
        // "POST /<TARGETNAME_FROM_URI>/<HANDBACK_STRING> HTTP/1.1
        //System.out.println("before in.readLine()");
		String headerMessage = in.readLine( );
		//System.out.println("headerMessage: [" + headerMessage+"]");
		//System.out.flush(); 
        if (headerMessage == null) {
			return false;
		}
        int endIndex = (headerMessage.substring( 6 )).indexOf(" ");
        // Retrieve "/<TARGETNAME_FROM_URI>/<HANDBACK_STRING>" from the
        // Header  
        // We have used 6 as the starting index because we need to
        // strip off "POST " from the Header
        headerMessage = headerMessage.substring( 6, (endIndex+6) );
        endIndex = headerMessage.indexOf( "/" );
        String listenerTargetName = null;
        String handbackString = null;
        // If handbackString is present then get that from the URI
        // or else it's null
        if( endIndex != -1 ) {
            listenerTargetName = headerMessage.substring( 0, endIndex );
            handbackString = headerMessage.substring( endIndex + 1 );
        } else {
            listenerTargetName = headerMessage;
        }
        //System.out.println( "listenerTargetName = " + listenerTargetName );
        //System.out.println( "handbackString = " + handbackString );
        do {
            headerMessage = in.readLine( );
           //hh System.out.println( "headerMessage [" + headerMessage+"]" );
        } while( headerMessage.regionMatches(true,0,"Content-Length:",0, "Content-Length:".length())  != true );
       
        int contentLength = 
            new Integer( headerMessage.substring( 
                CONTENT_LENGTH_SIZE )).intValue( );
            
        // Now get the serialized NotificationListener XML object
        int c = 0;
        for(int i = 0 ; i < (contentLength+1); i++ ) {
            c = in.read();
            xmlMessage.append( (char) c );
        } 
        int beginIndex = 0;

        // These extra setps are to clean up any special characters added
        // before or after the Serialized XML Doc.
        String stringifiedNotificationObject = xmlMessage.toString( );
        beginIndex = stringifiedNotificationObject.indexOf( "<?xml version" );
        endIndex = stringifiedNotificationObject.indexOf( 
            "</local-notification-object>" );
        endIndex = 
            endIndex + (new String("</local-notification-object>")).length( );
        stringifiedNotificationObject = stringifiedNotificationObject.substring(
            beginIndex, endIndex ); 

        LocalNotificationObject lNotification = new LocalNotificationObject( );
        try {
            // We first unmarshal the Notification Object into LocalNotification
            // Object and then we get the javax.management.Notification out of
            // the LocalNotificationObject. These extra steps are required
            // because javax.management.Notification is not following the
            // JavaBean pattern (No No Arg Constructor).
            lNotification = (LocalNotificationObject) Unmarshaller.unmarshal( 
                lNotification.getClass( ),
                new StringReader(stringifiedNotificationObject));
            NotificationListener listener = 
                (NotificationListener) clientListenerRegistry.get( 
                     listenerTargetName );
            listener.handleNotification( lNotification.getNotificationObject( ), handbackString );
        } catch( Exception e ) {
            System.err.println( e );
            e.printStackTrace( );
            return false;
        }
        return true;
    }


    /**
     * This is the central repository for every client to register for
     * events.
     */
    public void add( NotificationListener listener ) {
        clientListenerRegistry.put( String.valueOf(listener.hashCode()), listener );
    } 


    public String getUri( ) {
        return uri;
    }
}
