/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import javax.management.Attribute;

import java.util.Date;
import java.util.ArrayList;
import java.text.SimpleDateFormat;

public class Utility {

    private static final String STRING = "java:java.lang.String";
    private static final String INTEGER = "java:java.lang.Integer";
    private static final String BOOLEAN = "java:java.lang.Boolean";
    private static final String FLOAT = "java:java.lang.Float";
    private static final String LONG = "java:java.lang.Long";
    private static final String DOUBLE = "java:java.lang.Double";
    private static final String DATE = "date";
    private static final String ARRAYLIST = "java:java.util.ArrayList";

    public synchronized static Attribute createAttribute( 
        String name, String type, String[] parsedStrings ) 
    {
        if( parsedStrings.length == 1 ) {
            return createSimpleAttribute( name, type, parsedStrings[0] );
        } 
        return createComplexAttribute( name, type, parsedStrings );
    }


    private static Attribute createSimpleAttribute( 
        String name, String type, String value ) 
    {
        Object object = createSimpleJavaObject( type, value );
        if( object == null ) {
            object = "dummy";
        }
        return new Attribute( name, object );
    }    

    private static Object createSimpleJavaObject( String type, String value ) {
        if( type.equals( STRING ) ) {
            return value;
        } else if( type.equals( INTEGER ) ) {
            return new Integer( value );
        } else if( type.equals( BOOLEAN ) ) {
            return new Boolean( value );
        } else if ( type.equals( FLOAT ) ) {
            return new Float( value );
        } else if ( type.equals( LONG ) ) {
            return new Long( value );
        } else if( type.equals( DOUBLE ) ) {
            return new Double( value );
        } else if( type.equals( DATE ) ) {
            try {
                    return new SimpleDateFormat(
                        "yyyy-MM-dd'T'HH:mm:ss").parse(value);
            } catch ( Exception e ) {
                System.err.println( e );
            }
        }
        return null;
    }



    private static Attribute createComplexAttribute( 
        String name, String type, String[] parsedStrings)
    {
        if( type.equals( ARRAYLIST ) ) {
            return new Attribute( name, createArrayList( parsedStrings ) );
        }
        return new Attribute( name, "dummy" );
    }


    private static ArrayList createArrayList( String[] typevaluePairs ) {
        ArrayList arrayList = new ArrayList( );
        for( int i = 0; i < 2; i = i + 2 ) {
            arrayList.add( createSimpleJavaObject( 
                typevaluePairs[i], typevaluePairs[i+1] ) );
        }
        return arrayList;
    }
}
