/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import java.io.*;

import org.xml.sax.*;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

import org.exolab.castor.xml.Unmarshaller; 
import org.exolab.castor.xml.Marshaller; 
import javax.management.MBeanInfo;
import java.io.StringWriter;

public class MBeanInfoSerializer {
   public static String marshal( MBeanInfo mBeanInfo ) {
       try {
           StringWriter writer = new StringWriter( );

           // Marshal the person object
           Marshaller.marshal(mBeanInfo, writer);
  
           return writer.toString( );
       } catch( Exception e ) {
           System.err.println( e );
           e.printStackTrace( );
       }
       // To Keep Javac happy
       return null;
   }

   public static MBeanInfo unmarshal( String serializedMBeanInfo ) {
       try {
           SAXParserFactory factory = SAXParserFactory.newInstance();

           SAXParser saxParser = factory.newSAXParser();

           MBeanInfoSaxHandler mbeanSaxHandler = new MBeanInfoSaxHandler( );

           org.xml.sax.InputSource is = new org.xml.sax.InputSource( 
                   new StringReader( serializedMBeanInfo  ) );

           saxParser.parse( is , mbeanSaxHandler );

           return mbeanSaxHandler.getMBeanInfo( );
        } catch ( Exception e ) {
           System.err.println( e );
           e.printStackTrace( );
       }
       // To Keep Javac happy
       return null;
   }
       
}
