/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import java.io.*;

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;

import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanInfo;

public class MBeanInfoSaxHandler extends DefaultHandler
{

    //===========================================================
    // SAX DocumentHandler methods
    //===========================================================

    private static final int ATTRIBUTE_ELEMENT = 1;
    private static final int OPERATION_ELEMENT = 2;
    private static final int CLASSNAME_ELEMENT = 3;
    private static final int DESCRIPTION_ELEMENT = 4;
    private static final int CONSTRUCTOR_ELEMENT = 5;
    private static final int NOTIFICATION_ELEMENT = 6;

    private static final String ATTRIBUTES = "attributes";
    private static final String OPERATIONS = "operations";
    private static final String CLASSNAME = "class-name";
    private static final String CONSTRUCTORS = "constructors";
    private static final String DESCRIPTION = "description";
    private static final String SIGNATURE = "signature";
    private static final String NOTIFICATIONS = "notifications";
    private static final String NOTIFICATION_TYPES = "notif-types";

    int currentElementParsed = 0;

    private ArrayList attributeInfoList;
    private ArrayList operationInfoList;
    private ArrayList constructorInfoList;
    private ArrayList notificationInfoList;

    private String className;
    private String description;

    private MBeanInfo mBeanInfo; 
    

    private String[] attributeNames;
    private String[] attributeValues;

    private String[] fieldNames;
    private String[] fieldValues;


    private int signatureCount;
    private int notificationTypesCount;


    public MBeanInfoSaxHandler( ) {
        attributeNames = new String[100];
        attributeValues = new String[100];
        fieldNames = new String[100];
        fieldValues = new String[100];
    }
    private int attrCount;

    private int fieldCount;

    

    public MBeanInfo getMBeanInfo( ) {
        return mBeanInfo;
    }

    public void startDocument()
    throws SAXException
    {
    }

    public void endDocument()
    throws SAXException
    {
        try {
            buildMBeanInfo( );
        } catch (Exception e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void startElement(String namespaceURI,
                             String lName, // local name
                             String qName, // qualified name
                             Attributes attrs)
    throws SAXException
    {
        String eName = lName; // element name
        if ("".equals(eName)) eName = qName; // namespaceAware = false

        if( eName.equals( ATTRIBUTES ) ) {
            fieldCount = 0;
            attrCount = 0;
            signatureCount = 0;
            currentElementParsed = ATTRIBUTE_ELEMENT;
        } else if( eName.equals( OPERATIONS ) ) {
            fieldCount = 0;
            attrCount = 0;
            signatureCount = 0;
            currentElementParsed = OPERATION_ELEMENT; 
        } else if( eName.equals( CLASSNAME ) ) {
            fieldCount = 0;
            attrCount = 0;
            signatureCount = 0;
            currentElementParsed = CLASSNAME_ELEMENT; 
        } else if( eName.equals( DESCRIPTION ) 
                && (currentElementParsed == CLASSNAME_ELEMENT) ) 
        {
            fieldCount = 0;
            attrCount = 0;
            signatureCount = 0;
            currentElementParsed = DESCRIPTION_ELEMENT; 
        } else if( eName.equals( CONSTRUCTORS ) ) {
            fieldCount = 0;
            attrCount = 0;
            signatureCount = 0;
            currentElementParsed = CONSTRUCTOR_ELEMENT; 
        } else if( eName.equals( NOTIFICATIONS) ) {
            fieldCount = 0;
            attrCount = 0;
            signatureCount = 0;
            notificationTypesCount = 0;
            currentElementParsed = NOTIFICATION_ELEMENT;
        } else {
            fieldNames[fieldCount] = eName;
        } 
        if (attrs != null) {
            attrCount = attrs.getLength();
            for (int i = 0; i < attrs.getLength(); i++) {
                String aName = attrs.getLocalName(i); // Attr name 
                if ("".equals(aName)) aName = attrs.getQName(i);
                attributeNames[i] = aName;
                attributeValues[i] = attrs.getValue(i);
            }
        }
    }

    public void endElement(String namespaceURI,
                           String sName, // simple name
                           String qName  // qualified name
                          )
    throws SAXException
    {
        if( qName.equals( ATTRIBUTES ) ) {
            buildAttributeInfo( );
        } else if( qName.equals( OPERATIONS ) ) {
            buildOperationInfo( );
        } else if( qName.equals( CLASSNAME ) ) {
            buildClassName( );
        } else if( (qName.equals( DESCRIPTION ) ) 
                 &&(currentElementParsed == DESCRIPTION_ELEMENT) )
        {
            buildDescription( );
        } else if( qName.equals( CONSTRUCTORS ) ) {
            buildConstructorInfo( );
        } else if( qName.equals( SIGNATURE ) ) {
            signatureCount++;
        } else if( qName.equals( NOTIFICATION_TYPES ) ) {
            notificationTypesCount++;
        } else if( qName.equals( NOTIFICATIONS ) ) {
            buildNotificationInfo( );
            notificationTypesCount = 0;
        }
    }

    public void characters(char buf[], int offset, int len)
    throws SAXException
    {
        String s = new String(buf, offset, len);
        fieldValues[fieldCount++] = s;
    }

    //===========================================================
    // Utility Methods ...
    //===========================================================


    private void buildAttributeInfo( ) {
        boolean isR = new Boolean( attributeValues[0] ).booleanValue();
        boolean isW = new Boolean( attributeValues[1] ).booleanValue();
        boolean isIs = new Boolean( attributeValues[2] ).booleanValue();
        MBeanAttributeInfo attrInfo = new MBeanAttributeInfo( fieldValues[0],
            fieldValues[1], fieldValues[2], isR, isW, isIs );
        if( attributeInfoList == null ) {
            attributeInfoList = new ArrayList( );
        }
        attributeInfoList.add( attrInfo );
    }



    private void buildOperationInfo( ) {
        int impact = 0;
        try { impact = new Integer( attributeValues[0] ).intValue( );
        } catch (java.lang.NumberFormatException nfe) {
            //System.out.println("bad impact value " + attributeValues[0]);
        }
        MBeanParameterInfo[] parameterList =
            new MBeanParameterInfo[signatureCount];
        int index = 0;
        for( int i = 0; i < signatureCount; i++ ) {
            String name = fieldValues[index++];
            String type = fieldValues[index++];
            String description = null;
            if( ( fieldNames[index] != null )
              &&( fieldNames[index].equals(DESCRIPTION) ) )
            {
                description = fieldValues[index++];
            }
            parameterList[i] = new MBeanParameterInfo(
                                   name, type, description );
        }
        MBeanOperationInfo opInfo = new MBeanOperationInfo( 
            fieldValues[index], fieldValues[index+2], parameterList,
            fieldValues[index+1], impact ); 

        if( operationInfoList == null ) {
            operationInfoList = new ArrayList( );
        }
        operationInfoList.add( opInfo );
    }

    private void buildConstructorInfo( ) {
        MBeanParameterInfo[] parameterList = 
            new MBeanParameterInfo[signatureCount];
        int index = 0;
        for( int i = 0; i < signatureCount; i++ ) {
            String name = fieldValues[index++];
            String type = fieldValues[index++];
            String description = null;
            if( ( fieldNames[index] != null )
              &&( fieldNames[index].equals(DESCRIPTION) ) )
            {
                description = fieldValues[index++];
            }
            parameterList[i] = new MBeanParameterInfo( 
                                   name, type, description );
        }
        MBeanConstructorInfo constructorInfo = new MBeanConstructorInfo( 
             fieldValues[index++], fieldValues[index++], parameterList );
        if( constructorInfoList == null ) {
            constructorInfoList = new ArrayList( );
        }
        constructorInfoList.add( constructorInfo );
    }

    private void buildNotificationInfo( ) {
        String[] notificationTypes = new String[notificationTypesCount];
        int i = 0;
        for( ; i < notificationTypesCount; i++ ) {
            notificationTypes[i] = fieldValues[i];
        }
        MBeanNotificationInfo notificationInfo = new MBeanNotificationInfo(
            notificationTypes, fieldValues[i], fieldValues[i+1] );
        if( notificationInfoList == null ) {
            notificationInfoList = new ArrayList( );
        }
        notificationInfoList.add( notificationInfo );
    }
            

    private void buildClassName( ) {
        className = fieldValues[0];
    }

    private void buildDescription( ) {
        description = fieldValues[0];
    }


    private void buildMBeanInfo( ) {
        try {
            MBeanNotificationInfo[] notificationInfoArray; 
            MBeanAttributeInfo[] attributeInfoArray; 
            MBeanConstructorInfo[] constructorInfoArray; 
            MBeanOperationInfo[] operationInfoArray;

            if( notificationInfoList != null ) {
                notificationInfoArray = 
                   (MBeanNotificationInfo[]) notificationInfoList.toArray(
                    new MBeanNotificationInfo[0] );
            } else {
                notificationInfoArray = new MBeanNotificationInfo[0];
            }

            if( attributeInfoList != null ) {
                attributeInfoArray = 
                (MBeanAttributeInfo[]) attributeInfoList.toArray(
                    new MBeanAttributeInfo[0] );
            } else {
                attributeInfoArray = new MBeanAttributeInfo[0];
            }

            if( constructorInfoList != null ) {
                constructorInfoArray = 
                (MBeanConstructorInfo[]) constructorInfoList.toArray(
                    new MBeanConstructorInfo[0] );
            } else {
                constructorInfoArray = new MBeanConstructorInfo[0];
            } 
                  
            if( operationInfoList != null ) {
                operationInfoArray = 
                (MBeanOperationInfo[]) operationInfoList.toArray(
                    new MBeanOperationInfo[0] );
            } else {
                operationInfoArray = new MBeanOperationInfo[0];
            } 
            mBeanInfo = new MBeanInfo( className, description, 
                    attributeInfoArray, constructorInfoArray,
                    operationInfoArray, notificationInfoArray );
        } catch ( Exception e ) {
            System.err.println( e );
            e.printStackTrace( );
        }
    }
}
