/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import java.net.*;
import java.io.*;
import javax.management.NotificationListener;
import com.sun.enterprise.management.agent.*;
import org.exolab.castor.xml.Marshaller;

/**
 * HttpNotifier to Notify JSR 77 events. It takes
 * a javax.management.Notification object and serializes into XML and
 * sends it with a HTTP POST message.
 */
public class HttpNotifier implements NotificationListener {
    
    private String httpURL;
    
    public HttpNotifier( String url ) {
        httpURL = url;
    }
    
    public void handleNotification( javax.management.Notification notification, Object handback) {
        try {
            LocalNotificationObject localNotificationObject =
            new LocalNotificationObject( notification );
            
            StringWriter writer = new StringWriter( );
            Marshaller.marshal( localNotificationObject, writer );
            String xmlString = writer.toString( );
            
            HttpURLConnection httpConnection = (HttpURLConnection)new URL(httpURL).openConnection();
            
            httpConnection.setDoInput(true);
            httpConnection.setDoOutput(true);
            httpConnection.setUseCaches(false);
            httpConnection.setDefaultAllowUserInteraction( true );
            httpConnection.setDefaultUseCaches(false);
            
            httpConnection.setRequestMethod( "POST" );
            
            //System.out.println( xmlString );
            
            PrintStream out = new PrintStream( new BufferedOutputStream(
            httpConnection.getOutputStream() ));
            
            out.println( xmlString );
            out.flush( );
            out.close( );
            System.out.println(this.toString() + " Sent:\n" + xmlString );
            System.out.println( this.toString() + " Response Code = " + ((HttpURLConnection)httpConnection).getResponseCode() );
            System.out.flush( );
            
            
            
            
        } catch ( java.net.ConnectException ce ) {
            try {
                MEJBUtility.getMEJBUtility().removeNotificationListener((javax.management.ObjectName)notification.getSource(), this);
                System.err.println("automatic removal of listener:: " + httpURL + " from " + notification.getSource());
            } catch (Exception e) {
                System.err.println(this.toString() + "::" + e);
            }
            
        } catch( Exception e ) {
            System.err.println( e );
            e.printStackTrace( );
        }
    }
}
