/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import java.io.*;

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;

import javax.management.AttributeList;
import javax.management.Attribute;

import java.util.Date;
import java.text.DateFormat;

public class AttributeListSaxHandler extends DefaultHandler
{

    //===========================================================
    // SAX DocumentHandler methods
    //===========================================================

    private static final String ATTRIBUTE = "attributes";

    private String name;

    boolean valueBegin = false;
    boolean nameBegin = false;

    String[] parsedString;

    int parsedStringCount;

    String type;


    private AttributeList attributeList; 


    public AttributeListSaxHandler( ) {
        attributeList = new AttributeList( );
        parsedString = new String[2];
        parsedStringCount = 0;
    }

    public AttributeList getAttributeList( ) {
        return attributeList;
    }

    public void startDocument()
    throws SAXException
    {
    }

    public void endDocument()
    throws SAXException
    {
    }

    

    public void startElement(String namespaceURI,
                             String lName, // local name
                             String qName, // qualified name
                             Attributes attrs)
    throws SAXException
    {
        String eName = lName; // element name
        if ("".equals(eName)) eName = qName; // namespaceAware = false
        if( eName.equals( "name" ) ) {
            parsedStringCount = 0;
            nameBegin = true;
        } else if ( eName.equals( "value" ) ) {
            parsedStringCount = 0;
            valueBegin = true;
            type = attrs.getValue(0);
        } else if (valueBegin == true ){ 
            parsedString[parsedStringCount++] = attrs.getValue(0);
        }
    }

    public void endElement(String namespaceURI,
                           String sName, // simple name
                           String qName  // qualified name
                          )
    throws SAXException
    {
        if( qName.equals( "name" ) ) {
            name = parsedString[0];
            parsedStringCount = 0;
        } else if( qName.equals( "value" ) ) {
            String[] allParsedStrings = new String[ parsedStringCount ];
            for( int i = 0; i < parsedStringCount; i++ ) {
                allParsedStrings[i] = parsedString[i];
            }
            attributeList.add( 
                Utility.createAttribute( name, type, allParsedStrings ) );
            parsedStringCount = 0;
        }
    }

    public void characters(char buf[], int offset, int len)
    throws SAXException
    {
        ensureCapacity( );
        parsedString[parsedStringCount++] = new String(buf, offset, len);
    }

    private void ensureCapacity( ) {
        if( parsedString.length == parsedStringCount ) {
            int oldCapacity = parsedString.length;
            int newCapacity = oldCapacity + 30;
            String[] oldData = parsedString;
            String[] parsedString = new String[newCapacity];
            System.out.println( "oldCapacity = " + oldCapacity );
            System.out.println( "newCapacity = " + newCapacity );
            System.arraycopy(oldData, 0, parsedString, 0, oldCapacity);
        }
    }

}
