/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/* $Id: JndiServlet.java,v 1.4 2004/11/14 07:35:43 tcfujii Exp $
 *
 */

package samples.webapps.simple.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.naming.NamingException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;

/**
 * Demonstration of the web application environment support.
 *
 * @author Remy Maucherat
 */

public class JndiServlet 
    extends HttpServlet {

    ResourceBundle rb = ResourceBundle.getBundle("LocalStrings");

    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        
        PrintWriter out = response.getWriter();
        response.setContentType("text/plain");
        
        Context ctx = null;
        
        try {
            ctx = new InitialContext();
        } catch (NamingException e) {
            out.println(rb.getString("jndi.notinitialcontext") + e);
            return;
        }

        try {
            Object value = ctx.lookup("java:comp/env/maxExemptions");
            out.println(rb.getString("jndi.simplelookuptest"));
            out.println(rb.getString("jndi.Maxexemptionsvalue") + value);
        } catch (NamingException e) {
            out.println(rb.getString("jndi.lookupfailed") + e);
        }

        try {
            Context envCtx = (Context) ctx.lookup("java:comp/env");
            out.println(rb.getString("jndi.listoncompenv"));
            NamingEnumeration namingEnumeration = ctx.list("java:comp/env");
            while (namingEnumeration.hasMoreElements()) {
                out.print(rb.getString("jndi.binding"));
                out.println(namingEnumeration.nextElement().toString());
            }
            out.println(rb.getString("jndi.listBindingsoncompenv"));
            namingEnumeration = ctx.listBindings("java:comp/env");
            while (namingEnumeration.hasMoreElements()) {
                out.print(rb.getString("jndi.binding"));
                out.println(namingEnumeration.nextElement().toString());
            }
        } catch (NamingException e) {
            out.println(rb.getString("jndi.lookupfailed") + e);
        }
        
    }
    
    
}

