/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/* $Id: HelloWorldExample.java,v 1.3 2004/11/14 07:35:43 tcfujii Exp $
 *
 */

package samples.webapps.simple.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * The simplest possible servlet.
 *
 * @author James Duncan Davidson
 */

public class HelloWorldExample extends HttpServlet {


    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        ResourceBundle rb =
            ResourceBundle.getBundle("LocalStrings",request.getLocale());
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        out.println("<html>");
        out.println("<head>");

	    String title = rb.getString("helloworld.title");

	    out.println("<title>" + title + "</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        try {
            BufferedReader br = request.getReader();
            //AEMout.println( "getReader() method did not throw UnsupportedEncodingException" );
        } catch (Throwable t) {
            if ( !(t instanceof UnsupportedEncodingException) ) {
                out.println("Exception thrown, but was not an instance of IllegalStateException.");
                out.println("instead received: " + t.getClass().getName());
            }
        }


	// note that all links are created to be relative. this
	// ensures that we can move the web application that this
	// servlet belongs to to a different place in the url
	// tree and not have any harmful side effects.

        // XXX
        // making these absolute till we work out the
        // addition of a PathInfo issue

	out.println("<a href=\"" + request.getContextPath() + "/servlets/helloworld.html\">");
        out.println("<img src=\"" + request.getContextPath() + "/images/code.gif\" height=24 " +
                    "width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"" + request.getContextPath() + "/servlets/index.html\">");
        out.println("<img src=\"" + request.getContextPath() + "/images/return.gif\" height=24 " +
                    "width=24 align=right border=0 alt=\"return\"></a>");
        out.println("<h1>" + title + "</h1>");
        out.println("</body>");
        out.println("</html>");
    }
}



