/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/**
*  EJB Bean class
*  @author Jagadesh 
*  @author Amurillo
*/
package samples.security.ldaprealm.dynamicgroup.ejb;


import java.util.*;
import javax.ejb.*;
import java.rmi.*;
import javax.naming.InitialContext;


public class SecAuthSampleBean implements SessionBean 
{

    private SessionContext sctx = null;
    private InitialContext nctx = null;

    /*
     * Stateless Session Bean lifecycle methods
     */
    public void setSessionContext(SessionContext sc)  
    {
        sctx = sc;
        System.out.println("SecAuthTestBean::setSessionContext(sc) invoked.");
    }
  
    public void ejbCreate() 
                throws CreateException  
    { 
        System.out.println("SecAuthTestBean::ejbCreate() invoked.");
    }  

    public void ejbRemove() 
    { 
        System.out.println("SecAuthTestBean::ejbRemove() invoked.");
    }

    public void ejbActivate() 
    { 
        System.out.println("SecAuthTestBean::ejbActivate() invoked.");
    }

    public void ejbPassivate() 
    { 
        System.out.println("SecAuthTestBean::ejbPassivate() invoked.");
    }

    /*
     * Business methods - Security authorization tests
     */
    
    /**
    * Positively test the expected caller identity in the role
    * @return false  Test failed 
    */
    
    public boolean testIsCallerExpected(String caller) 
    {
        String principal = sctx.getCallerPrincipal().getName();
        System.out.println("SecAuthTestBean::testIsCallerExpected(" + caller + ") invoked.");
        System.out.println("...Got Principal: <" + principal + ">");

        return !(principal.indexOf(caller) < 0 );
    }

    /*
     * Test positively is caller in proper role?
     */
    
    public boolean testIsCallerInRole(String role) 
    {
        System.out.println("SecAuthTestBean::testIsCallerInRole(" + role + ") invoked.");
        try 
        {
            boolean result =  sctx.isCallerInRole(role);
            System.out.println("...isCallerInRole() returned:" + result + "; role=" + role);
            return result;
        } catch ( Exception e ) {
	    e.printStackTrace();
            return false;
        }
    }

    /*
     * This method should be authorized in the descriptor
     */
    
    public boolean methodIsAuthorized() 
    {
        System.out.println("SecAuthTestBean::methodIsAuthorized() invoked as expected.");
        return true; //this method expected to be authorized.
    }

    /*
     * Test that method was NOT authorized in the descriptor
     */
    
    public boolean methodIsNotAuthorized() 
    {
        System.out.println("SecAuthTestBean::methodIsNotAuthorized() invoked as unexpected!");
        return true; //this method expected to be not authorized.
    }

    /*
     * This method was excluded in the descriptor
     */
    
    public boolean methodIsExcluded()
    {
        System.out.println("SecAuthTestBean::methodIsExcluded() invoked as unexpected!");
        return true;
    }
}
