/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.rmi.simple.client;

import java.util.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.math.BigDecimal;
import samples.rmi.simple.ejb.*;

/**
 * A simple java client. This uses the services provided by 
 * the ConverterBean.
 */

public class ConverterClient {

   /*
    * The main method of the client. This invokes the converter bean to use its service.
    * It then asks the bean to convert 100 dollars to yen and 100 yen to euro.
    * The results are printed at the terminal where the client is run.
    * See appclient documentation in Sun Java System Application Server to run the clinet.
    *
    */
   public static void main(String[] args) {
       String url = null;
       String jndiname = null;
       boolean acc = true;


       try {

          if (args.length == 1) {
	      jndiname = args[0];
	      acc = false;
	  }

  	   Context initial;
	   Object objref;
	   jndiname = (acc ? "java:comp/env/ejb/RMICConverter" : jndiname) ;
   	   initial = new InitialContext();
           objref = initial.lookup(jndiname);

	   /*if (acc) {
	      initial = new InitialContext();
	      Context myEnv = (Context)initial.lookup("java:comp/env");
	      objref = myEnv.lookup("ejb/RMICConverter");
	   } else {
	      Properties env = new Properties();
	      initial = new InitialContext(env);
	      objref = initial.lookup(jndiname);
	   }*/

           ConverterHome home =
               (ConverterHome)PortableRemoteObject.narrow(objref,
                                            ConverterHome.class);

           Converter currencyConverter = home.create();

           BigDecimal param = new BigDecimal ("100.00");
           BigDecimal amount = currencyConverter.dollarToYen(param);
           System.out.println(amount);
           amount = currencyConverter.yenToEuro(param);
           System.out.println(amount);

           System.exit(0);

       } catch (Exception ex) {
          //ResourceBundle rb = ResourceBundle.getBundle("LocalStrings", Locale.getDefault());
          //System.err.println(rb.getString("caught_exception")+"!");
          System.err.println("Caught an unexpected exception !");
	  ex.printStackTrace();
       }
   }
}
