/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package carstore;

import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

public class FirstNameChanged extends Object implements ValueChangeListener {

    public void processValueChange(ValueChangeEvent event)
        throws AbortProcessingException {
        if (null != event.getNewValue()) {
            FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap()
                .put("firstName", event.getNewValue());
        }
    }


    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

}
    
