/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.jndi.external.share;

import java.util.Hashtable;
import java.util.Properties;
import java.io.ByteArrayInputStream;
import javax.naming.spi.ObjectFactory;
import javax.naming.*;

public class ExternalRepositoryImplFactory
    implements ObjectFactory 
{
    
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable)
        throws Exception 
    {
        if (object instanceof Reference) 
        {
            Reference reference = (Reference)object;
            // Checks whether or not its a valid reference for this factory.
            if (reference.getClassName().equals(ExternalRepositoryImpl.class.getName())) 
            {
                RefAddr refaddr = reference.get("properties");
                if (refaddr != null) 
                {
                    if (refaddr instanceof BinaryRefAddr) 
                    {
                        BinaryRefAddr binaryrefaddr = (BinaryRefAddr)refaddr;
                        // Recreates the stored properties.
                        byte [] props = (byte [])binaryrefaddr.getContent();
                        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(props);
                        Properties properties = new Properties();
                        properties.load(bytearrayinputstream);
                        return new ExternalRepositoryImpl(properties);
                    }
                }
            }
        }
        return null;
    }
}
