/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * @author amurillo
 */

package samples.jndi.external.client;

import java.io.*;
import java.util.*;
import java.net.URL;
import java.beans.Beans;
import javax.ejb.EJBHome;
import javax.naming.*;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.BasicAttributes;

import samples.jndi.external.share.*;

public class JndiExternalRepositoryAppClient 
{

    public static void main (String[] args) 
    {
        /** for (int i = 0; i < args.length; i++) 
        {
            System.out.println("ARG[" + i + "] = " + args[i]);
        } **/
             
        if (args.length < 2) 
        {
            System.out.println("Usage: JndiExternalRepositoryAppClient  <URL> STORE [name class]...");
            System.out.println("Usage: JndiExternalRepositoryAppClient  <URL> LOOKUP [name] ...");
            System.out.println("Usage: JndiExternalRepositoryAppClient  <URL> CREATE [name] ...");
            System.exit(1);
        }
        
        // Load the properties from the supplied URL/File
        
        String propertiesFileName = args[0];
        Properties properties     = new Properties();
        
        try 
        {
            if ( propertiesFileName.startsWith("http") )
                properties.load(new URL(propertiesFileName).openStream());
            else
                properties.load(new FileInputStream(propertiesFileName));
        } catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
        }
                 
        String command = args[1];
        
        if ( command.equals("LOOKUP") ) {        
            lookupObjects(properties, args);
        } else if ( command.equals("STORE") ) {
            storeObjects(properties, args);
        } else if ( command.equals("CREATE") ) {
            bindExternalRepository(properties);
        }
        
    }
    
    public static void lookupObjects(Properties properties, String[] args ) 
    {
        //System.out.println("Looking up objects");
        try 
        {
            DirContext dircontext = new InitialDirContext(properties);
            // Get the name of the External Repository
            String repositoryName = properties.getProperty("external.repository.name");
            // Lookup a External Repository using the specified name.
            ExternalRepository externalRepository = (ExternalRepository)
                                                    dircontext.lookup(repositoryName);
            dircontext.close();
        
            for (int i = 2; i < args.length; i++) 
            {
                System.out.println("Looking up: " + args[i]);
                Object object = externalRepository.retrieveObject(args[i]);
                // Dump its info if possible
                if (object != null && object instanceof ExternalBean) 
                {
                    ((ExternalBean)object).dumpInfo();
                }
            } 
        } catch (Exception exception) {
            System.out.println("JndiExternalRepositoryAppClient::lookupObjects: caught an exception");
            exception.printStackTrace();
            System.exit(1);
        }
    }
        
    private static void storeObjects(Properties properties, String[] args ) 
    {
        try 
        {
            DirContext dircontext = new InitialDirContext(properties);
            // Get the name of the External Repository
            String repositoryName = properties.getProperty("external.repository.name");
            // Lookup a External Repository using the specified name.
            ExternalRepository externalRepository = (ExternalRepository)
                                                    dircontext.lookup(repositoryName);
            dircontext.close();
            
            for (int i = 2; i < args.length; i+=2) 
            {
                System.out.println("Storing <" + args[i + 1] + "> as " + args[i]);
                Class myClass = Class.forName( args[i + 1] );
                Object object = Beans.instantiate(myClass.getClassLoader(), args[i + 1]);           
                if (object != null && object instanceof ExternalBean) 
                {
                    ((ExternalBean)object).setJndiName(args[i]);
                }
                externalRepository.storeObject(object, args[i], new HashMap());
            }
        } catch (Exception exception) {
            System.out.println("JndiExternalRepositoryAppClient::storeObjects: caught an exception");
            exception.printStackTrace();
            System.exit(1);
        }
    }
    
    private static void bindExternalRepository(Properties properties) 
    {        
        try 
        {
	    DirContext dircontext = new InitialDirContext(properties);
            
            // Create a new instance of the External Repository
            
	    ExternalRepository externalRepository = new ExternalRepositoryImpl(properties);
            
            // Get the JNDI name for the Repository.
            String jndiName = properties.getProperty("external.repository.name");
            
            // Bind the external repository to the specified name.
	    dircontext.rebind(jndiName, externalRepository, null);
            
            System.out.println("External repository bound to <" + 
                                jndiName + "> at this external factory: <" +
                                properties.getProperty("java.naming.provider.url"));
            
            // Close the context.
	    dircontext.close();
        } catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}
