/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/**
*  Custom JNDI Factory
*  @author amurillo
*/
  	
	
package samples.jndi.custom.share;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;


public class MyJndiCustomFactory implements ObjectFactory 
{
    public Object getObjectInstance(Object    obj, 
                                    Name      name, 
                                    Context   nameCtx, 
                                    Hashtable environment)
        throws NamingException 
   {
        // Acquire an instance of the custom bean class
        CustomBean bean = new CustomBean();

        // Customize the bean properties from  provided attributes
        Reference ref = (Reference) obj;
        Enumeration addrs = ref.getAll();
        
        while (addrs.hasMoreElements()) 
        {
            RefAddr addr = (RefAddr) addrs.nextElement();
            String  propertyName = addr.getType();
            String value = (String) addr.getContent();
            if (propertyName.equals("propertyOne")) 
            {
                bean.setPropertyOne(value);
            } else if (propertyName.equals("propertyTwo")) {
                try 
                {
                    bean.setPropertyTwo(Integer.parseInt(value));
                } catch (NumberFormatException e) {
                    throw new NamingException("Invalid 'propertyTwo' value " + value);
                }
            }
        }

      // Return the customized instance
      return (bean);
    }
  }
