/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * @author amurillo
 */

package samples.jndi.custom.client;

import java.io.*;
import java.util.*;
import javax.ejb.EJBHome;
import javax.naming.*;

import samples.jndi.custom.share.*;

public class JndiCustomFactoryAppClient 
{

    public static void main (String[] args) 
    {
        try
        {
            Context    initCtx = new InitialContext();
    
            //Context    envCtx  = (Context) initCtx.lookup("java:comp/env");
            //CustomBean bean    = (CustomBean) envCtx.lookup("bean/CustomBean");
            
            CustomBean bean    = (CustomBean) initCtx.lookup("bean/CustomBean");

            System.out.println("PropertyOne = "   + bean.getPropertyOne() + 
                               ", PropertyTwo = " + bean.getPropertyTwo());
        } catch (NameNotFoundException e) { 
            System.out.println("Name <bean/customBean> not found.");
            System.out.println("Try asant create-custom-resource before runnng the application");
        } catch (Exception e) { 
            System.out.println("Caught Exception");
            e.printStackTrace();
        }
    }
}
