<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<!--
 Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
-->
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<fmt:setBundle basename="LocalStrings"/>

<%@ page language="java" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collection" %>
<%@ page import="javax.ejb.ObjectNotFoundException" %>
<%@ page import="javax.naming.InitialContext" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalCustomer" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalCustomerHome" %>
<%@ page import='java.util.*' %>
 
<html>

<head><title><fmt:message key="cmp_demo_title"/></title></head>
<body bgcolor="white">
<center>
<h2><fmt:message key="cmp_demo_title"/> </h2>

<fmt:message key="search_for_customer"/> :
<p>
    <form method="get" action="/customer/searchCustomer.jsp">
    Search by 
    <select name="searchCriteria">
      <option value="customerID" selected><fmt:message key="customer_id"/> 
      <option value="lastName"><fmt:message key="last_name"/> 
      <option value="firstName"><fmt:message key="first_name"/> 
    </select>
    <input type="text" name="searchText" size="25">
    <p>
    <input type="submit" value=<fmt:message key="search"/> >
    </form>

<%
String text = request.getParameter("searchText");
String criteria = request.getParameter("searchCriteria");

if (text != null && !"".equals(text)) {
    try {
        InitialContext ic = new InitialContext();
        Object o = ic.lookup("java:comp/env/CustomerBeanRef");
        LocalCustomerHome home = (LocalCustomerHome) o;

        Collection customers = new ArrayList();
        if ("customerID".equals(criteria)) {
          try {
            LocalCustomer customer = home.findByPrimaryKey(text);
            customers.add(customer);
          } catch (ObjectNotFoundException ex) {}
        }	  
        else if ("lastName".equals(criteria)) {
          customers = home.findByLastName(text);
        } else if ("firstName".equals(criteria)) {
          customers = home.findByFirstName(text);
        } else {
        }
  

%>
<fmt:message key="results"/> : <p>
<%
for (int i = 0; i < customers.size(); i++) {
  LocalCustomer c = (LocalCustomer)((ArrayList)customers).get(i);
  String cid = (String)c.getPrimaryKey();
%>
<a href="/customer/editCustomer.jsp?cid=<%=cid%>"> 
<%=c.getLastName()%>, <%=c.getFirstName()%></a> has
<%=c.getAddressList().size()%> addresses,
<%=c.getSubscriptionList().size()%> subscriptions.
<p>
<%
}
%>
<%
    } catch(Exception e) {
        e.printStackTrace();
        out.println(e.toString());
    }
}
%>

<hr>
[<a href="/customer/index.html"><fmt:message key="home"/> </a>]
</center>
</body>
</html>
