/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * @(#)JavaMailServiceImpl.java	
 */

package samples.connectors.mailconnector.ra.inbound;

import javax.mail.*;
import javax.mail.internet.*;

import java.util.*;
import java.util.logging.*;
import javax.resource.*;
import javax.resource.spi.*;
import javax.resource.spi.endpoint.*;
import javax.resource.spi.work.*;
import javax.resource.cci.*;

/**
 * 
 * @author Alejandro Murillo
 *
 */

public class DeliveryThread  implements Work 
{
    public static final Logger  logger = 
        Logger.getLogger("samples.connectors.mailconnector.ra.inbound");
    static ResourceBundle 	resource = 
        java.util.ResourceBundle.getBundle("samples.connectors.mailconnector.ra.inbound.LocalStrings"); 

    private EndpointConsumer  endpointConsumer;
    
    /**
     * Constructor.
     */

    public DeliveryThread(EndpointConsumer endpointConsumer)
    {
        this.endpointConsumer = endpointConsumer;
        
        logger.info("[DeliveryThread::Constructor] Leaving");

    }

    /**
     * release: called by the WorkerManager
     */

    public void release()
    {
        logger.info("[DT] Worker Manager called release for deliveryThread ");
    }

    /**
     * run
     */

    public void run()
    { 
	//logger.info("[DT] WorkManager started delivery thread ");
                
        try
	{
            endpointConsumer.deliverMessages();
        } catch (Exception te) {
            logger.info("deliveryThread::run got an exception");
            te.printStackTrace();
        }
        
	//logger.info("[DT] DeliveryThread leaving");
    }    
}
