/* Copyright 2004 Sun Microsystems, Inc.  All rights reserved.  You may not modify, use, reproduce, or distribute this software except in compliance with the terms of the License at: 
 http://adventurebuilder.dev.java.net/LICENSE.txt
 $Id: LodgingSupplierClient.java,v 1.5 2004/05/26 00:07:02 inder Exp $ */

package com.sun.j2ee.blueprints.opc.webservicebroker.requestor;

import javax.xml.rpc.*;
import javax.naming.*;

import com.sun.j2ee.blueprints.opc.JNDINames;

public class LodgingSupplierClient implements WSClient {

    public String sendRequest(String xmlDoc) {
  String ret = null;
  try {
      InitialContext ic = new InitialContext();
      LodgingPurchaseOrderService svc = (LodgingPurchaseOrderService) 
    ic.lookup(JNDINames.LODGING_SERVICE_NAME);
      String endpointURI = (String)
    ic.lookup(JNDINames.LODGING_SERVICE_URL);
      LodgingPOIntf port=(LodgingPOIntf)svc.getPort(LodgingPOIntf.class);

      // Required here because the sample app built the stubs using
      // static WSDL
      ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
              endpointURI);
      ret = port.submitLodgingReservationDetails(xmlDoc);
  } catch(Exception ex) {
            /* 
             *  Advanced error handling will be done for a later release, with 
             * the broker placing an error message in the work flow manager
             * queue so that the work flow manager can again call the broker
             * to send the PO to the proper supplier
             */ 
            System.err.println(ex);
  }
  return ret;
    }
}
