/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package storage;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;


public class UpdateAttributes extends HttpServlet implements Serializable {
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        HttpServletRequest req = request;
        HttpSession session = request.getSession(false);
        
        request.removeAttribute("income");
        request.removeAttribute("phone");
        
        session.setAttribute("income", req.getParameter("income"));
        session.setAttribute("phone", req.getParameter("phone"));
        
        out.println("<html>");
        out.println("<head><title>Update Attributes Servlet</title></head>");
        out.println("<body bgcolor=#FFFFFF>");
        out.println("<h1> Session data after updating attributes </h1>");
        out.println("<B>");
        out.println("   The session ID = " + session.getId() + "<br><br>");
        out.println("   Name:  " + session.getAttribute("name") + "<br>");
        out.println("   Sex:  " + session.getAttribute("sex") + "<br>");
        out.println("   Income:  " + session.getAttribute("income") + "<br>");
        out.println("   Phone Number:  " + session.getAttribute("phone") + "<br>");
        out.println("</B>");
        out.println("<p><a href=index.html>Main Page</a></p> ");
        out.println("</body>");
        out.println("</html>");
        
        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
        
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    
}
