/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package storage;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;


public class TakeAttributeData extends HttpServlet implements Serializable {
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        HttpSession session = request.getSession();
        Person p = new Person(request);
        p.addToSession();
        
        out.println("<html>");
        out.println("<head><title>Session Attributes Data Servlet</title></head>");
        out.println("<body bgcolor=#FFFFFF>");
        out.println("<br><b> Input Data for <b>");
        out.println("<B>the session ID  " + session.getId() + "<br><br>");
        out.println("     Name:   " + session.getAttribute("name") + "<br>");
        out.println("     Sex:  " + session.getAttribute("sex") + "<br>");
        out.println("     Income:  " + session.getAttribute("income") + "<br>");
        out.println("     Phone Number:  " + session.getAttribute("phone") + "<br>");
        out.println("<form method=post action=\"ModifyAttribute.jsp\"> ");
        out.println("<input type=submit name=Submit value=UpdateAttribute>");
        out.println("</B></form> ");
        out.println("</body>");
        out.println("</html>");

        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    
}
