/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.sfsbfailover.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import javax.naming.InitialContext;
import samples.sfsbfailover.ejb.*;
import javax.rmi.PortableRemoteObject;
import samples.sfsbfailover.tools.*;
import javax.ejb.RemoveException;
/**
 *
 * @author  root
 * @version 1.0
 */
public class StoreServlet extends HttpServlet {
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, java.io.IOException {
        response.setContentType("text/html");
        RequestDispatcher dispatcher = null;
        String book="";
        boolean addBook = false;
        boolean removeBook = false;
        
        if (request.getParameter("AddBook") != null) {
            addBook = true;
        } else if(request.getParameter("RemoveBook") != null) {
            removeBook = true;
        }
        
        Vector booklist = new Vector();
        CartHome home = null;
        Cart shoppingCart = null;
        String message="";
        
        if (request.getSession().getAttribute("Cart") == null) {
            try {
                InitialContext initial = new InitialContext();
                Object objref = initial.lookup("java:comp/env/ejb/Cart");
                home =(CartHome)PortableRemoteObject.narrow(objref,
                CartHome.class);
                //shoppingCart = home.create(name,id);
                shoppingCart = home.create();
                request.getSession().setAttribute("Cart",shoppingCart);
                
            } catch(Exception ex) {
                ex.getMessage();
                ex.printStackTrace();
            }
            
        } else {
            shoppingCart = (Cart)request.getSession(false).getAttribute("Cart");
        }
        
        
        try {
            if (addBook) {
                book = (String)request.getParameter("BookTitle");
                
                if(shoppingCart != null) {
                    if(book != null) {
                        shoppingCart.addBook(book);
                        message = "Added book to your cart";
                    } else
                        message = "Please specify the book name to be added.";
                } else
                    message = "Get your cart first";
            }
            
            if (removeBook) {
                book = (String)request.getParameter("BookTitle");
                
                if (shoppingCart != null) {
                    if ( book != null) {
                        shoppingCart.removeBook(book);
                        message = " Removed the book \"" + book + "\" from the cart";
                        
                    } else
                        message = "Please specify the book name to be removed.";
                    
                } else
                    message = " Get your cart first";
            }
            
        } catch(BookException bookEx) {
            message = bookEx.getMessage();
            //System.err.println("Unreported Book Exception -----"+ex.getMessage());
            //ex.printStackTrace();
        } catch(Exception ex){
            System.err.println("Unreported exception ---"+ex.getMessage());
            ex.printStackTrace();
        }
        
        if(shoppingCart != null) {
            booklist = shoppingCart.getContents();
            
            if (booklist == null) {
                booklist = new Vector();
            }
            
            request.setAttribute("Books",booklist);
            
        } else {
            message = "Get your cart first";
        }
        
        request.setAttribute("Books",booklist);
        request.setAttribute("Message", message);
        
        System.out.println("Dispatching JSP for output...");
        dispatcher = getServletContext().getRequestDispatcher("/cart.jsp");
        dispatcher.include(request, response);
        System.out.println("- Dispatched JSP successfully");
        System.out.println("\npage1 is all done\n");
        return;
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, java.io.IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, java.io.IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    
}
