/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package samples.sfsbfailover.ejb;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * Home interface for the <code>CartBean</code>. Clients generally use home interface
 * to obtain references to the bean's remote interface, <code>Cart</code>.
 *
 * @see Cart
 * @see CartBean
 */
public interface CartHome extends EJBHome {
    
    /**
     * Gets a reference to the remote interface of the <code>CartBean</code>.
     * @exception throws CreateException and RemoteException.
     *
     */
    Cart create() throws RemoteException, CreateException;
}
