/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package samples.sfsbfailover.ejb;


import java.util.*;
import javax.ejb.*;
import samples.sfsbfailover.tools.BookException;

/**
 * A simple stateful bean. This bean demonstrates how a bean retains state information
 * across method calls and within the same session. Typical use of a stateful session
 * bean is a shopping cart and this sample tries to simulate the same. The cart keeps the
 * name of the customer, id of the customer and a list of books. Initially the list remains
 * empty.
 * <p>
 * Clients using this bean can add and remove books to the list. The state of the bean can
 * be verified by listing down the books in the bean.
 *
 * @see Cart
 * @see CartHome
 */
public class CartBean implements SessionBean {
    
    Vector contents = null;
    
    /**
     * Creates a bean.
     * @exception throws CreateException, RemoteException.
     */
    public void ejbCreate() throws CreateException {
        contents = new Vector();
    }
    
    /**
     * Adds a book to the cart.
     * @param title title of the book.
     * @return boolean True if added the book, false if the book already exists
     * @exception RemoteException
     */
    public void addBook(String title) throws BookException {
        if (!contents.contains(title)) {
            contents.addElement(title);
        } else if(title.trim().length() < 1) {
            throw new BookException("Blank title cannot be added.");
        } else {
            throw new BookException("\"" + title + "\" already exists in cart.");
        }
    }
    
    /**
     * Removes a book from the cart.
     * @param title title of the book.
     * @exception RemoteException, BookException
     */
    public void removeBook(String title) throws BookException {
        if(contents.contains(title)) {
            contents.removeElement(title);
        } else {
            throw new BookException("Book \"" + title + "\" not in cart.");
        }
    }
    
    /**
     * Gets the content.
     * @return Vector containing books.
     * @exception RemoteException
     */
    public Vector getContents() {
        return contents;
    }
    
    /**
     * Creates a bean. Required by EJB spec.
     */
    public CartBean() {}
    
    /**
     * Removes the bean. Required by EJB spec.
     */
    public void ejbRemove() {}
    
    /**
     * Loads the state of the bean from secondary storage. Required by EJB spec.
     */
    public void ejbActivate() {}
    
    /**
     * Keeps the state of the bean to secondary storage. Required by EJB spec.
     */
    public void ejbPassivate() {}
    
    /**
     * Sets the session context. Required by EJB spec.
     * @param sc A SessionContext object.
     */
    public void setSessionContext(SessionContext sc) {}
    
}
