/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package roster;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import javax.ejb.*;

import team.*;
import util.*;

public class ListData extends HttpServlet implements Serializable {
    
    HttpSession session;

    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        out.close();        
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        out.println("<html>");
        out.println("<head><title>CMP Roster Having LocalEJBHome Reference Stored in HttpSession</title></head>");
        out.println("<body bgcolor=white>");
        out.println("<BR><BR><B> Display Selection</B><BR>");
        out.println("<FORM method=POST action=\"/RosterClient/ListData\">");
        out.println("<TABLE border=0>");
        out.println(" <TR valign=center>");
        out.println("   <TD align=right><B>Choose Listing option    </B></TD>");
        out.println("    <TD align=left>");
        out.println("      <INPUT type=RADIO name=option value=\"leagueList\">  List of League<BR>");
        out.println("      <INPUT type=RADIO name=option value=\"teamList\">  List of Team<BR>");
        out.println("      <INPUT type=RADIO name=option value=\"playerList\">  List of All Players<BR>");
        out.println("      <INPUT type=RADIO name=option value=\"sport\">  Players of Sport<BR>");
        out.println("      <INPUT type=RADIO name=option value=\"league\">  Players of League<BR>");
        out.println("      <INPUT type=RADIO name=option value=\"team\">  Players of Team<BR>");
        out.println("      <INPUT type=RADIO name=option value=\"noteam\">  Players not in Team");
        out.println("    </TD> </TR>");
        out.println(" <TR valign=top>");
        out.println("    <TD colspan=2 align=center>");
        out.println("      <INPUT type=SUBMIT value=Submit>");
        out.println("    </TD></TR></TABLE></FORM>");
        out.println("</body></html>");
        out.close();
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        String option = (String)request.getParameter("option");        
        if (option.equals("leagueList"))
            LeagueList(request, response);
        else if (option.equals("teamList"))
            TeamList(request, response);
        else if (option.equals("playerList"))
            PlayerList(request, response);
        else if (option.equals("sport"))
            SportList(request, response);
        else if (option.equals("league"))
            PlayerLeague(request, response);
        else if (option.equals("team"))
            PlayerTeam(request, response);
        else if (option.equals("noteam"))
            PlayerNotInTeam(request, response);

        out.close();
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "ListData servlet for CMP Roster Application";
    }

    public void LeagueList(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();        
        LeagueDetails leagueDetails;
        session = request.getSession(false);
        out.println("<html>");
        try {
            out.println("<head><title>RosterApp: List of League</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>List of League</B><BR><BR>");
            leagueDetails = getLeague("L1");
            out.println("<DL><DT><DD>" + leagueDetails.toString());
            leagueDetails = getLeague("L2");
            out.println("<DD>" + leagueDetails.toString());
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    public void TeamList(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ArrayList teamList;
        session = request.getSession(false);
        out.println("<html>");
        try {
            out.println("<head><title>RosterApp: List of Team</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>List of Team</B><BR><BR>");
            out.println("<DL><DT><B>League Mountain: </B><BR>");
            teamList = getTeamsOfLeague("L1");
            Iterator i = teamList.iterator();
            while (i.hasNext()) {
                Object details = (Object)i.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }                
            out.println("<DT><B>League Valley: </B><BR>");
            teamList = getTeamsOfLeague("L2");
            Iterator j = teamList.iterator();
            while (j.hasNext()) {
                Object details = (Object)j.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }                
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    public void PlayerList(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();        
        ArrayList playerList;
        session = request.getSession(false);
        out.println("<html>");
        try {          
            out.println("<head><title>RosterApp: List of All Players</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>List of All Players</B><BR>");
            out.println("<DL><DT>");
            playerList = getAllPlayers();
            Iterator p = playerList.iterator();
            while (p.hasNext()) {
            Object details = (Object)p.next();
            out.println("<DD>" + details.toString() + "<BR>");
            }
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    public void SportList(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ArrayList playerList;
        session = request.getSession(false);
        out.println("<html>");
        try {     
            out.println("<head><title>RosterApp: Players of Sport</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>Player of Sport</B><BR>");
            out.println("<BR><DL><DT><B> *** Basketball: </B><BR>");
            playerList = getPlayersBySport("Basketball");
            Iterator t = playerList.iterator();
            while (t.hasNext()) {
                Object details = (Object)t.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
           out.println("<BR><DT><B> *** Soccer: </B><BR>");
           playerList = getPlayersBySport("Soccer");
           Iterator u = playerList.iterator();
           while (u.hasNext()) {
               Object details = (Object)u.next();
               out.println("<DD>" + details.toString() + "<BR>");
           }
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    public void PlayerLeague(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ArrayList teamList;
        session = request.getSession(false);
        out.println("<html>");
        try {
            out.println("<head><title>RosterApp: Players of League</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>Players of League</B><BR>");
            teamList = getPlayersByLeagueId("L1");
            out.println("<BR><DL><DT><B> League Mountain: </B><BR>");
            Iterator i = teamList.iterator();
            while (i.hasNext()) {
                Object details = (Object)i.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
            teamList = getPlayersByLeagueId("L2");
            out.println("<BR><DT><B> League Valley: </B><BR>");
            Iterator j = teamList.iterator();
            while (j.hasNext()) {
                Object details = (Object)j.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    public void PlayerTeam(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ArrayList playerList;
        session = request.getSession(false);
        out.println("<html>");
        try {
            out.println("<head><title>RosterApp: Players of Team</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>Players of Team</B><BR>");               
            playerList = getPlayersOfTeam("T1");
            out.println("<BR><DL><DT> Team 1: ");
            Iterator i = playerList.iterator();
            while (i.hasNext()) {
                Object details = (Object)i.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
            playerList = getPlayersOfTeam("T2");
            out.println("<BR><DT> Team 2: ");
            Iterator j = playerList.iterator();
            while (j.hasNext()) {
                Object details = (Object)j.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
            playerList = getPlayersOfTeam("T3");
            out.println("<BR><DT> Team 3: ");
            Iterator k = playerList.iterator();
            while (k.hasNext()) {
                Object details = (Object)k.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
            playerList = getPlayersOfTeam("T4");
            out.println("<BR><DT> Team 4: ");
            k = playerList.iterator();
            while (k.hasNext()) {
                Object details = (Object)k.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
            playerList = getPlayersOfTeam("T5");
            out.println("<BR><DT> Team 5: ");
            k = playerList.iterator();
            while (k.hasNext()) {
                Object details = (Object)k.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    public void PlayerNotInTeam(HttpServletRequest request, HttpServletResponse response)
    throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ArrayList playerList;
        session = request.getSession(false);
        out.println("<html>");
        try {
            out.println("<head><title>RosterApp: Players Not In Team</title></head>");
            out.println("<body bgcolor=white>");
            out.println("<B>Players Not In Team</B><BR>");
            playerList = getPlayersNotOnTeam();                
            out.println("<DL><DT> ");
            Iterator i = playerList.iterator();
            while (i.hasNext()) {
                Object details = (Object)i.next();
                out.println("<DD>" + details.toString() + "<BR>");
            }
        } catch (Exception ex) {
            out.println("Caught an exception: " + ex.toString());
        }
        out.println("</DL><BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
        out.println("<a href=RosterDispatcher?choice=list>Selection Page</a> ");
        out.println("&nbsp;&nbsp;&nbsp;<a href=index.jsp>Main Page</a> ");
        out.println("</body></html>");
        out.close();
    }
    
    //=======================================================================
    public LeagueDetails getLeague(String leagueId) {
        Debug.print("Roster getLeague");
        LeagueDetails leagueDetails = null;
        try {
            LocalLeagueHome leagueHome = (LocalLeagueHome)session.getAttribute("leagueHome");
            LocalLeague league = leagueHome.findByPrimaryKey(leagueId);
            leagueDetails = new LeagueDetails(leagueId, league.getName(), league.getSport());
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
        return leagueDetails;
    }

    public TeamDetails getTeam(String teamId) {
        Debug.print("Roster getTeam");
        TeamDetails teamDetails = null;
        try {
            LocalTeamHome teamHome = (LocalTeamHome)session.getAttribute("teamHome");
            LocalTeam team = teamHome.findByPrimaryKey(teamId);
            teamDetails = new TeamDetails(teamId, team.getName(), team.getCity());
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
        return teamDetails;
    }
    
    public ArrayList getAllPlayers() { 
        Debug.print("Roster getAllPlayers");
        Collection players = null;
        try {
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            players = playerHome.findAll();
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
        return copyPlayersToDetails(players);
    } // getAllPlayers
    
    private ArrayList copyPlayersToDetails(Collection players) {
        ArrayList detailsList = new ArrayList();
        Iterator i = players.iterator();
        while (i.hasNext()) {
            LocalPlayer player = (LocalPlayer) i.next();
            PlayerDetails details = new PlayerDetails(player.getPlayer_Id(),
                player.getName(), player.getPosition(), player.getSalary());
            detailsList.add(details);
        }
        return detailsList;
    } // copyPlayersToDetails
    
    public ArrayList getPlayersBySport(String sport) { 
        Debug.print("Roster getPlayersBySport");
        Collection players = null;
        try {
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            players = playerHome.findBySport(sport);
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }

        return copyPlayersToDetails(players);
    } // getPlayersBySport
    
    public ArrayList getPlayersByLeagueId(String leagueId) { 
        Debug.print("Roster getPlayersByLeagueId");
        Collection players = null;
        try {
            LocalLeagueHome leagueHome = (LocalLeagueHome)session.getAttribute("leagueHome");
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            LocalLeague league = leagueHome.findByPrimaryKey(leagueId);
            players = playerHome.findByLeague(league);
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
        return copyPlayersToDetails(players);
    } // getPlayersByLeagueId

    public ArrayList getPlayersOfTeam(String teamId) { 
        Debug.print("Roster getPlayersOfTeam");
        ArrayList players = new ArrayList();
        try {
            LocalTeamHome teamHome = (LocalTeamHome)session.getAttribute("teamHome");
            LocalTeam team = teamHome.findByPrimaryKey(teamId);
            players = team.getCopyOfPlayers();
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
        return players;
    } // getPlayersOfTeam
    
    public ArrayList getPlayersNotOnTeam() { 
        Debug.print("Roster getPlayersNotOnTeam");
        Collection players = null;
        try {
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            players = playerHome.findNotOnTeam();
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
        return copyPlayersToDetails(players);
    } // getPlayersNotOnTeam

    public ArrayList getTeamsOfLeague(String leagueId) {
        Debug.print("RosterBean getTeamsOfLeague");
        ArrayList teams = new ArrayList();
        try {
            LocalLeagueHome leagueHome = (LocalLeagueHome)session.getAttribute("leagueHome");
            LocalLeague league = leagueHome.findByPrimaryKey(leagueId);
            teams = league.getCopyOfTeams();
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }        
        return teams;
    } // getTeamsOfLeague

}
