/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package roster;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.ejb.*;

import team.*;
import util.*;


public class InsertData extends HttpServlet implements Serializable {
    
    HttpSession session;
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        session = request.getSession(false);
        out.println("<html>");
        out.println("<head><title>CMP Roster Having LocalEJBHome Reference Stored in HttpSession</title></head>");
        out.println("<body bgcolor=white>");
        out.println("<BR><BR>Inserting data, please wait ...........");            

        try {      
            out.println("<BR><BR>Inserting leagues");
            // Leagues
            createLeague(new LeagueDetails("L1", "Mountain", "Soccer"));
            createLeague(new LeagueDetails("L2", "Valley", "Basketball"));

            // Teams
            out.println("<BR><BR>Inserting teams");
            createTeamInLeague(new TeamDetails("T1", "Honey Bees", "Visalia"), "L1");           
            createTeamInLeague(new TeamDetails("T2", "Gophers", "Manteca"), "L1");
            createTeamInLeague(new TeamDetails("T3", "Deer", "Bodie"), "L2");
            createTeamInLeague(new TeamDetails("T4", "Trout", "Truckee"), "L2");
            createTeamInLeague(new TeamDetails("T5", "Crows", "Orland"), "L1");

            // Players, Team T1
            out.println("<BR><BR>Inserting players for team 1");
            createPlayer(new PlayerDetails("P1", "Phil Jones", "goalkeeper", 100.00));
            addPlayer("P1", "T1");

            createPlayer(new PlayerDetails("P2", "Alice Smith", "defender", 505.00));
            addPlayer("P2", "T1");

            createPlayer(new PlayerDetails("P3", "Bob Roberts", "midfielder", 65.00));
            addPlayer("P3", "T1");

            createPlayer(new PlayerDetails("P4", "Grace Phillips", "forward", 100.00));
            addPlayer("P4", "T1");

            createPlayer(new PlayerDetails("P5", "Barney Bold", "defender", 100.00));
            addPlayer("P5", "T1");

            // Players, Team T2
            out.println("<BR><BR>Inserting players for team 2");
            createPlayer(new PlayerDetails("P6", "Ian Carlyle", "goalkeeper", 555.00));
            addPlayer("P6", "T2");

            createPlayer(new PlayerDetails("P7", "Rebecca Struthers", "midfielder", 777.00));
            addPlayer("P7", "T2");

            createPlayer(new PlayerDetails("P8", "Anne Anderson", "forward", 65.00));
            addPlayer("P8", "T2");

            createPlayer(new PlayerDetails("P9", "Jan Wesley", "defender", 100.00));
            addPlayer("P9", "T2");

            createPlayer(new PlayerDetails("P10", "Terry Smithson", "midfielder", 100.00));
            addPlayer("P10", "T2");

            // Players, Team T3
            out.println("<BR><BR>Inserting players for team 3");
            createPlayer(new PlayerDetails("P11", "Ben Shore", "point guard", 188.00));
            addPlayer("P11", "T3");

            createPlayer(new PlayerDetails("P12", "Chris Farley", "shooting guard", 577.00));
            addPlayer("P12", "T3");

            createPlayer(new PlayerDetails("P13", "Audrey Brown", "small forward", 995.00));
            addPlayer("P13", "T3");

            createPlayer(new PlayerDetails("P14", "Jack Patterson", "power forward", 100.00));
            addPlayer("P14", "T3");

            createPlayer(new PlayerDetails("P15", "Candace Lewis", "point guard", 100.00));
            addPlayer("P15", "T3");

            // Players, Team T4
            out.println("<BR><BR>Inserting players for team 4");
            createPlayer(new PlayerDetails("P16", "Linda Berringer", "point guard", 844.00));
            addPlayer("P16", "T4");

            createPlayer(new PlayerDetails("P17", "Bertrand Morris", "shooting guard", 452.00));
            addPlayer("P17", "T4");

            createPlayer(new PlayerDetails("P18", "Nancy White", "small forward", 833.00));
            addPlayer("P18", "T4");

            createPlayer(new PlayerDetails("P19", "Billy Black", "power forward", 444.00));
            addPlayer("P19", "T4");

            createPlayer(new PlayerDetails("P20", "Jodie James", "point guard", 100.00));
            addPlayer("P20", "T4");

            // Players, Team T5
            out.println("<BR><BR>Inserting players for team 5");
            createPlayer(new PlayerDetails("P21", "Henry Shute", "goalkeeper", 205.00));
            addPlayer("P21", "T5");

            createPlayer(new PlayerDetails("P22", "Janice Walker", "defender", 857.00));
            addPlayer("P22", "T5");

            createPlayer(new PlayerDetails("P23", "Wally Hendricks", "midfielder", 748.00));
            addPlayer("P23", "T5");

            createPlayer(new PlayerDetails("P24", "Gloria Garber", "forward", 777.00));
            addPlayer("P24", "T5");

            createPlayer(new PlayerDetails("P25", "Frank Fletcher", "defender", 399.00));
            addPlayer("P25", "T5");

            // Players, no team
            out.println("<BR><BR>Inserting players without team");
            createPlayer(new PlayerDetails("P26", "Hobie Jackson", "pitcher", 582.00));

            createPlayer(new PlayerDetails("P27", "Melinda Kendall", "catcher", 677.00));

            // Players, multiple teams
            out.println("<BR><BR>Inserting players for mutiple teams");
            createPlayer(new PlayerDetails("P28", "Constance Adams", "substitue", 966.00));
            addPlayer("P28", "T1");
            addPlayer("P28", "T3");
                       
            out.println("<BR><BR> Done! <BR><BR>");
            out.println("<BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");
            out.println("<a href=index.jsp>Main Page</a> ");
            out.println("</body>");
            out.println("</html>");            
       } catch (Exception ex) {
            System.err.println("Caught an exception: " + ex.toString());
            ex.printStackTrace();
       }
        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "InsertData servlet for CMP Roster Application";
    }
    
    
    public void createLeague(LeagueDetails details) {  
        Debug.print("Roster createLeague");
        try {
            LocalLeagueHome leagueHome = (LocalLeagueHome)session.getAttribute("leagueHome");
            LocalLeague league = leagueHome.create(details.getId(), 
                details.getName(), details.getSport());
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
    }
    
    public void createPlayer(PlayerDetails details) {  
        Debug.print("Roster createPlayer");
        try {
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            LocalPlayer player = playerHome.create(details.getId(), 
                details.getName(), details.getPosition(), details.getSalary());
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
    }
 
    public void addPlayer(String playerId, String teamId) {  
        Debug.print("Roster addPlayer");
        try {
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            LocalTeamHome teamHome = (LocalTeamHome)session.getAttribute("teamHome");
            LocalTeam team = teamHome.findByPrimaryKey(teamId);
            LocalPlayer player = playerHome.findByPrimaryKey(playerId);
            team.addPlayer(player);
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
    }
    
    public void createTeamInLeague(TeamDetails details, String leagueId) {  
        Debug.print("Roster createTeamInLeague");
        try {
            LocalLeagueHome leagueHome = (LocalLeagueHome)session.getAttribute("leagueHome");
            LocalTeamHome teamHome = (LocalTeamHome)session.getAttribute("teamHome");
            LocalLeague league = leagueHome.findByPrimaryKey(leagueId);
            LocalTeam team = teamHome.create(details.getId(),
                details.getName(), details.getCity());
            league.addTeam(team);
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
    }
    
}
