<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<%@page contentType="text/html"%>
<%@page import="javax.ejb.*, javax.naming.*, javax.rmi.PortableRemoteObject, java.rmi.RemoteException" %>
<%@page import="java.util.*"%>
<%@page import="product.*"%>

<%!
    ProductHome home;

    public void jspInit() { 
      try {
	 InitialContext initContext = new InitialContext();
         Object objref = initContext.lookup("java:comp/env/ejb/Product");
         System.out.println("Lookup OK");
         home = (ProductHome)PortableRemoteObject.narrow(objref, ProductHome.class);
      } catch (Exception ex) {
          System.err.println("Caught an exception in jspInit");
          throw new RuntimeException (ex);
      }
    }
%>

<html>
<head><title>Storing an Entity Bean Reference in HTTPSession</title></head>
<body>
<H1>Storing an Entity Bean Reference in HTTPSession</H1>
<%
       try {
          boolean sessionInvalidated = false;
          if (request.getParameter("invalidate") != null) {
             session.invalidate();
             sessionInvalidated = true;
             out.println ("<font color=red>Session Invalidated</font>");
          } else {
             /* Get the input values.  These presense of these values also 
                what to diplay next. */
             String sProductId = request.getParameter("productid"); 
             String sPrice = request.getParameter("price")==null?"0":request.getParameter("price");        
             double dPrice = 0;
             try {
                dPrice = new Double(sPrice).doubleValue();
             } catch (Exception e) {
                out.println ("<font color=red>'" + sPrice + "' is not a valid price</font>");
             }
             /* If a product ID was entered, store the entity bean reference
                for that product in HTTPSession */
             if (sProductId != null) {
               try {
                  Product product = home.findByPrimaryKey(sProductId);
                  session.setAttribute("ProductBean", product);
                  out.println("<BR>The entity bean reference for product Id: " + product.getPrimaryKey() 
                       + "-" + product.getDescription() + " has been stored in HTTPSession.");
               } catch (ObjectNotFoundException e) {
                  out.println ("<font color=red>There is no entity bean associated with Product Id: " 
                            + sProductId + "</font>");
               }
               /* If a price was entered, get the product's entity bean reference 
                  from HTTPSession and update its price */
             } else if (dPrice > 0) {
                 Product product = (Product) session.getAttribute("ProductBean");
                 product.setPrice(dPrice);
                 out.println("<BR>The entity bean reference for product Id: " + product.getPrimaryKey() + "-" 
                       + product.getDescription() 
                       + " has been retrieved from HTTPSession with new price set");
             }
          }
%>
          <form method="get">
<%
          Product product = null;
          // Get the entity bean reference if the session is still valid
         if (! sessionInvalidated) { 
           product = (Product) session.getAttribute("ProductBean");
         }
         if (product == null) {
           /* There's no bean persisted, provide a text box for the 
              user the enter a bean id to persist */
%>
        <p>Each row in the table below represents an entity bean.<BR>  
        Enter the product ID of the entity bean to persist to HTTPSession:
        <input type="text" name="productid" size="7">
<% 
        /* An entity bean reference for product exists in session, 
           provide a text box for the user to update its price */
         } else { %>               
            <p>Enter a new price for   <%=product.getPrimaryKey()%>-<%=product.getDescription()  %>
            <input type="text" name="price" size="7">
<%       }  %>
         <input type="submit" value="Submit">               
<% 
         // Display the product data
         Collection c = home.findInRange(0, 1000000);
         if (c.isEmpty()) { // First time?, populate the table with sample data.
           home.create("Ceramic Dog", 10.00, "123");
           home.create("Wooden Duck", 13.00, "456");
           home.create("Ivory Cat", 19.00, "999");
           home.create("Ivory Cat", 33.00, "789");
           home.create("Chrome Fish", 22.00, "876");
           c = home.findInRange(0, 1000000);
         } 
         out.println("<p><table BORDER COLS=3>");
         out.println("<TR><TD><B>Product ID </TD><TD><B>Description </TD><TD><B>Price </TD></TR>");
         Iterator i = c.iterator();
         while (i.hasNext()) {
           product = (Product)i.next();
           String productId = (String)product.getPrimaryKey();
           String description = product.getDescription();
           double price = product.getPrice(); 
           out.println("<TR><TD>" + productId + "</TD><TD>" + description + "</TD><TD>"
                + java.text.NumberFormat.getCurrencyInstance().format(price) + "</TD></TR>");
         }
         out.println("</table>");
       } catch (Exception ex) {
           System.err.println("Caught an exception" );
           ex.printStackTrace();
       }
%>
       <p><input type="submit" name="invalidate" value="Invalidate Session">
       </form>
</body>
</html>
