/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.mqfailover.ejb;

import java.rmi.RemoteException;

import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;

import javax.jms.*;

import javax.naming.Context;
import javax.naming.InitialContext;


/**
 * A Simple CMT MDB attached to TopicA. On receiving a message that is not redelivered,
 * the MDB sleeps for 30 seconds so that one or more brokers in the broker cluster
 * are killed to simulate broker failure/shutdown-restart and then sends back a response 
 * to a ReplyQueue.
 *
 * @author Sivakumar Thyagarajan
 */
public class MQFailoverTestMDB implements MessageDrivenBean, MessageListener {

    private Context context;
    private QueueConnectionFactory factory;
    private Queue replyQueue;

    
    public void ejbCreate() throws RemoteException {
        try {
            context = new InitialContext();
            factory = (QueueConnectionFactory) context.lookup(
                            "java:comp/env/jms/BeanQCF"); 
        } catch(Throwable e) {
            System.out.println("MQFailoverTestMDB :: ejbCreate:  unexpected exception " +
                    "thrown in TopicConnectionFactory lookup:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext newMDC) {
    	System.out.println(" MQFailoverTestMDB : setMDC");
    }

    public void ejbRemove() {
    	System.out.println(" MQFailoverTestMDB : ejbRemove");
    }

    public void onMessage(Message msg) {
        System.out.println("MQFailoverTestMDB: onMessage - Message being delivered to MDB is:  " + msg);
        try {
         System.out.println("**** MQFailoverTestMDB: Message " +   ((TextMessage)msg).getText() 
                            + " msg.redelivered  " + msg.getJMSRedelivered()); 
        } catch (Exception ex) {
          ex.printStackTrace();
        }
        QueueConnection connection = null;
        QueueSession session = null;

        try {
            if (!msg.getJMSRedelivered()) {
		  try {
                	System.out.println("MDB Sleeping for 30 seconds");
		      	Thread.sleep(30 * 1000);
		   } catch (InterruptedException iex) {
		     	//ignore
		   }
            }
            
            System.out.println(" Sending back response for message " + msg);
            connection = factory.createQueueConnection();
            session = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
            replyQueue = (Queue) msg.getJMSReplyTo();

            // Create a message producer to replyQueue
            QueueSender sender = session.createSender(replyQueue);

            // add to message and "publish" it back
            TextMessage message        = session.createTextMessage();
            message.setText("Reply from MQFailoverTestMDB: \n for message : >> " 
                            + ((TextMessage)msg).getText() + "\n Message received at :: " 
                            + new java.util.Date() + " << " );
            message.setBooleanProperty("wasFailedOver", msg.getJMSRedelivered());
            sender.send(message);
            System.out.println("MQFailoverTestMDB: Published the message"+
                " back to replyQueue ");
            sender.close();
        } catch(Exception ex) {
            System.out.println("MQFailoverTestMDB: onMessage: exception " + ex.getMessage());
            ex.printStackTrace();
        } finally {
        	if (session != null) {
        		try {
        			session.close();
        		} catch (Exception ex) {
        			ex.printStackTrace();
        		}
        	}
            if( connection != null ) {
                try { 
                    connection.close(); 
                } catch(Exception e) {
                    System.out.println("MQFailoverTestMDB: onMessage:  exception " +
                            "on close " + e.getMessage());
                }
           }
        } 
    } 
}
