/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package bookstore.listeners;

import bookstore.database.BookDBAO;
import javax.servlet.*;

public final class ContextListener implements ServletContextListener {
    private ServletContext context = null;

    public void contextInitialized(ServletContextEvent event) {
         context = event.getServletContext();
         
         try {
            BookDBAO bookDBAO = new BookDBAO();
            context.setAttribute("bookDB", bookDBAO);
         } catch (Exception ex) {
            context.log("Couldn't create bookstore database bean: " + ex.getMessage());
         }
    }
      
    public void contextDestroyed(ServletContextEvent event) {
         context = event.getServletContext();
         BookDBAO bookDBAO = (BookDBAO)context.getAttribute("bookDB");
         bookDBAO.remove();
         context.removeAttribute("bookDB");
    }
}
