/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package bookstore;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class Dispatcher extends HttpServlet implements java.io.Serializable {
    
   public void doGet(HttpServletRequest request, HttpServletResponse response) {
      HttpSession session = request.getSession();
      ResourceBundle messages = (ResourceBundle)session.getAttribute("messages");
      if (messages == null) {
         Locale locale = request.getLocale();
         messages = ResourceBundle.getBundle("bookstore.messages.BookstoreMessages", locale); 
         session.setAttribute("messages", messages);
      }
      request.setAttribute("selectedScreen", request.getServletPath());
      try {
         request.getRequestDispatcher("/template.jsp").forward(request, response);
      } catch(Exception ex) {
         ex.printStackTrace();
      }
   }
   
   
   public void doPost(HttpServletRequest request, HttpServletResponse response) {     
      request.setAttribute("selectedScreen", request.getServletPath());
      try {
         request.getRequestDispatcher("/template.jsp").forward(request, response);
      } catch(Exception ex) {
         ex.printStackTrace();
      }
   }
}
