/*
 * Decompiled with CFR 0.152.
 */
package com.sun.httpservice.spi.monitor;

import com.sun.httpservice.spi.HttpService;
import com.sun.httpservice.spi.HttpServiceLogger;
import com.sun.httpservice.spi.HttpServiceSPIException;
import com.sun.httpservice.spi.monitor.ConnectionQueueMB;
import com.sun.httpservice.spi.monitor.DnsMB;
import com.sun.httpservice.spi.monitor.FileCacheMB;
import com.sun.httpservice.spi.monitor.HttpServiceMB;
import com.sun.httpservice.spi.monitor.KeepAliveMB;
import com.sun.httpservice.spi.monitor.ProfileMB;
import com.sun.httpservice.spi.monitor.RequestMB;
import com.sun.httpservice.spi.monitor.ThreadPoolMB;
import com.sun.httpservice.spi.monitor.VirtualServerMB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StatsUnmarshaller {
    boolean initConnQueueStatus;
    boolean initThreadPoolStatus;
    boolean updateConnQueueStatus;
    boolean updateThreadPoolStatus;
    private DocumentBuilderFactory dbFactory;
    private DocumentBuilder docBuilder;
    private HttpService httpService;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private long _initTreeTime;
    private long _updateTreeTime;
    private static StatsUnmarshaller unmarshaller = null;

    private StatsUnmarshaller() throws HttpServiceSPIException {
        this.dbFactory = DocumentBuilderFactory.newInstance();
        this.dbFactory.setValidating(false);
        try {
            this.docBuilder = this.dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new HttpServiceSPIException("httpservice.monitoring.newDocumentBuilder.failed", ex);
        }
        this.httpService = HttpService.getInstance();
    }

    public static synchronized StatsUnmarshaller getInstance() throws HttpServiceSPIException {
        if (unmarshaller == null) {
            unmarshaller = new StatsUnmarshaller();
        }
        return unmarshaller;
    }

    public static void main(String[] str) throws HttpServiceSPIException {
        HttpServiceMB hsMB = StatsUnmarshaller.getInstance().getHttpServiceStats();
    }

    public HttpServiceMB getHttpServiceStats() throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        this.initConnQueueStatus = false;
        this.initThreadPoolStatus = false;
        HttpServiceMB httpServiceMB = new HttpServiceMB();
        this._initTreeTime = System.currentTimeMillis();
        this.initHttpServiceMB(httpServiceMB, serverNode);
        return httpServiceMB;
    }

    public void updateHttpServiceStats(HttpServiceMB httpServiceMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        httpServiceMB.setUpdateTime(System.currentTimeMillis());
        try {
            this.populateHSMBeanAttributes(httpServiceMB, serverNode);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        catch (ParseException pe) {
            throw new HttpServiceSPIException("invalid.number.format", pe);
        }
    }

    public void updateHttpServiceStatsTree(HttpServiceMB httpServiceMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        this.updateConnQueueStatus = false;
        this.updateThreadPoolStatus = false;
        this._updateTreeTime = System.currentTimeMillis();
        this.updateHttpServiceMB(httpServiceMB, serverNode);
    }

    public void updateConnectionQueueStats(ConnectionQueueMB connQueueMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Element hsElement = (Element)serverNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        Node node = this.getChildNodeByTagName(processNode, "connection-queue-bucket");
        if (node != null) {
            try {
                this.populateConnectionQueueMB(connQueueMB, node);
                connQueueMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
            catch (ParseException pe) {
                throw new HttpServiceSPIException("invalid.number.format", pe);
            }
        }
    }

    public void updateThreadPoolStats(ThreadPoolMB threadPoolMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Element hsElement = (Element)serverNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        Node node = this.getChildNodeByTagName(processNode, "thread-pool-bucket");
        if (node != null) {
            try {
                this.populateThreadPoolMB(threadPoolMB, node);
                threadPoolMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
        }
    }

    public void updateDnsStats(DnsMB dnsMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Element hsElement = (Element)serverNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        Node node = this.getChildNodeByTagName(processNode, "dns-bucket");
        if (node != null) {
            try {
                this.populateDnsMB(dnsMB, node);
                dnsMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
        }
    }

    public void updateKeepAliveStats(KeepAliveMB keepAliveMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Element hsElement = (Element)serverNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        Node node = this.getChildNodeByTagName(processNode, "keepalive-bucket");
        if (node != null) {
            try {
                this.populateKeepAliveMB(keepAliveMB, node);
                keepAliveMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
        }
    }

    public void updateFileCacheStats(FileCacheMB fileCacheMB) throws HttpServiceSPIException {
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Element hsElement = (Element)serverNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        Node node = this.getChildNodeByTagName(processNode, "cache-bucket");
        if (node != null) {
            try {
                this.populateFileCacheMB(fileCacheMB, node);
                fileCacheMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
        }
    }

    public void updateVirtualServerStats(VirtualServerMB vsMB) throws HttpServiceSPIException {
        if (vsMB.getId() == null) {
            return;
        }
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Node vsNode = this.getElementByTagNameAndId(serverNode, "virtual-server", "id", vsMB.getId());
        if (vsNode != null) {
            this.populateVSMBeanAttributes(vsMB, vsNode);
            vsMB.setUpdateTime(System.currentTimeMillis());
        }
    }

    public void updateProfileStats(ProfileMB profileMB) throws HttpServiceSPIException {
        if (profileMB.getParentId() == null) {
            return;
        }
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Node vsNode = this.getElementByTagNameAndId(serverNode, "virtual-server", "id", profileMB.getParentId());
        if (vsNode == null) {
            return;
        }
        Node profileNode = this.getElementByTagNameAndId(vsNode, "profile-bucket", "profile", profileMB.getId());
        if (profileNode != null) {
            try {
                this.populateProfileMB(profileMB, profileNode);
                profileMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
        }
    }

    public void updateRequestStats(RequestMB requestMB) throws HttpServiceSPIException {
        if (requestMB.getParentId() == null) {
            return;
        }
        String statsXmlData = this.httpService.getMonitoringStats();
        Document doc = this.parseStatsXml(statsXmlData);
        Node serverNode = doc.getElementsByTagName("server").item(0);
        Node vsNode = this.getElementByTagNameAndId(serverNode, "virtual-server", "id", requestMB.getParentId());
        if (vsNode == null) {
            return;
        }
        NodeList requestNodeList = ((Element)vsNode).getElementsByTagName("request-bucket");
        if (requestNodeList.getLength() > 0) {
            Node reqNode = requestNodeList.item(0);
            try {
                this.populateRequestMB(requestMB, reqNode);
                requestMB.setUpdateTime(System.currentTimeMillis());
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
            catch (ParseException pe) {
                throw new HttpServiceSPIException("invalid.number.format", pe);
            }
        }
    }

    private Node getChildNodeByTagName(Node parent, String childTagName) {
        Node childNode = null;
        Node node = null;
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!childNode.getNodeName().equals(childTagName)) continue;
            childNode = node;
            break;
        }
        return childNode;
    }

    private Node getElementByTagNameAndId(Node parent, String childTagName, String idAttrName, String idAttrValue) {
        Element parentElem = (Element)parent;
        Node childNode = null;
        Node node = null;
        String id = null;
        NodeList nodeList = parentElem.getElementsByTagName(childTagName);
        for (int j = 0; j < nodeList.getLength(); ++j) {
            node = nodeList.item(j);
            id = node.getAttributes().getNamedItem(idAttrName).getNodeValue();
            if (!id.equals(idAttrValue)) continue;
            childNode = node;
            break;
        }
        return childNode;
    }

    private void initHttpServiceMB(HttpServiceMB httpServiceMB, Node hsNode) throws HttpServiceSPIException {
        httpServiceMB.setUpdateTime(this._initTreeTime);
        try {
            this.populateHSMBeanAttributes(httpServiceMB, hsNode);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        catch (ParseException pe) {
            throw new HttpServiceSPIException("invalid.number.format", pe);
        }
        Element hsElement = (Element)hsNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        this.initProcessMBeans(httpServiceMB, processNode);
        NodeList vsNodeList = hsElement.getElementsByTagName("virtual-server");
        this.initVSMBeans(httpServiceMB, vsNodeList);
    }

    private void populateHSMBeanAttributes(HttpServiceMB httpServiceMB, Node hsNode) throws ParseException {
        Node attrNode = null;
        NamedNodeMap nnm = hsNode.getAttributes();
        attrNode = nnm.getNamedItem("id");
        if (attrNode != null) {
            httpServiceMB.setId(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("versionServer")) != null) {
            httpServiceMB.setVersionServer(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("timeStarted")) != null) {
            httpServiceMB.setTimeStarted(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("secondsRunning")) != null) {
            httpServiceMB.setSecondsRunning(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("ticksPerSecond")) != null) {
            httpServiceMB.setTicksPerSecond(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxProcs")) != null) {
            httpServiceMB.setMaxProcs(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxThreads")) != null) {
            httpServiceMB.setMaxThreads(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxVirtualServers")) != null) {
            httpServiceMB.setMaxVirtualServers(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("flagProfilingEnabled")) != null) {
            httpServiceMB.setFlagProfilingEnabled(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("flagVirtualServerOverflow")) != null) {
            httpServiceMB.setFlagVirtualServerOverflow(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("load1MinuteAverage")) != null) {
            httpServiceMB.setLoad1MinuteAverage(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("load5MinuteAverage")) != null) {
            httpServiceMB.setLoad5MinuteAverage(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("load15MinuteAverage")) != null) {
            httpServiceMB.setLoad15MinuteAverage(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("rateBytesTransmitted")) != null) {
            httpServiceMB.setRateBytesTransmitted(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("rateBytesReceived")) != null) {
            httpServiceMB.setRateBytesReceived(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
    }

    private void initProcessMBeans(HttpServiceMB httpServiceMB, Node processNode) throws HttpServiceSPIException {
        NodeList processNodeList = processNode.getChildNodes();
        for (int i = 0; i < processNodeList.getLength(); ++i) {
            String name = processNodeList.item(i).getNodeName();
            if (name.equals("connection-queue-bucket") && !this.initConnQueueStatus) {
                this.initConnectionQueueMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (name.equals("thread-pool-bucket") && !this.initThreadPoolStatus) {
                this.initThreadPoolMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (name.equals("dns-bucket")) {
                this.initDnsMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (name.equals("keepalive-bucket")) {
                this.initKeepAliveMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (!name.equals("cache-bucket")) continue;
            this.initFileCacheMB(httpServiceMB, processNodeList.item(i));
        }
    }

    private void initConnectionQueueMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        ConnectionQueueMB connQueueMB = new ConnectionQueueMB();
        try {
            this.populateConnectionQueueMB(connQueueMB, node);
            connQueueMB.setUpdateTime(this._initTreeTime);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        catch (ParseException pe) {
            throw new HttpServiceSPIException("invalid.number.format", pe);
        }
        httpServiceMB.setConnectionQueueBean(connQueueMB);
        this.initConnQueueStatus = true;
    }

    private void initThreadPoolMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        ThreadPoolMB threadPoolMB = new ThreadPoolMB();
        try {
            this.populateThreadPoolMB(threadPoolMB, node);
            threadPoolMB.setUpdateTime(this._initTreeTime);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        httpServiceMB.setThreadPoolBean(threadPoolMB);
        this.initThreadPoolStatus = true;
    }

    private void initDnsMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        DnsMB dnsMB = new DnsMB();
        try {
            this.populateDnsMB(dnsMB, node);
            dnsMB.setUpdateTime(this._initTreeTime);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        httpServiceMB.setDnsBean(dnsMB);
    }

    private void initKeepAliveMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        KeepAliveMB keepAliveMB = new KeepAliveMB();
        try {
            this.populateKeepAliveMB(keepAliveMB, node);
            keepAliveMB.setUpdateTime(this._initTreeTime);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        httpServiceMB.setKeepAliveBean(keepAliveMB);
    }

    private void initFileCacheMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        FileCacheMB fileCacheMB = new FileCacheMB();
        try {
            this.populateFileCacheMB(fileCacheMB, node);
            fileCacheMB.setUpdateTime(this._initTreeTime);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        httpServiceMB.setFileCacheBean(fileCacheMB);
    }

    private void initVSMBeans(HttpServiceMB httpServiceMB, NodeList vsNodeList) throws HttpServiceSPIException {
        VirtualServerMB virtualServerMB = null;
        int vsCount = vsNodeList.getLength();
        for (int j = 0; j < vsCount; ++j) {
            virtualServerMB = new VirtualServerMB();
            Node node = vsNodeList.item(j);
            this.initVirtualServerMB(virtualServerMB, node);
            virtualServerMB.setUpdateTime(this._initTreeTime);
            httpServiceMB.addVirtualServer(virtualServerMB);
        }
    }

    private void initVirtualServerMB(VirtualServerMB vsMB, Node node) throws HttpServiceSPIException {
        NodeList profileNodeList;
        int nodeCount;
        this.populateVSMBeanAttributes(vsMB, node);
        NodeList reqNodeList = ((Element)node).getElementsByTagName("request-bucket");
        if (reqNodeList.getLength() > 0) {
            Node reqNode = reqNodeList.item(0);
            RequestMB requestMB = new RequestMB();
            try {
                this.populateRequestMB(requestMB, reqNode);
                requestMB.setUpdateTime(this._initTreeTime);
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
            catch (ParseException pe) {
                throw new HttpServiceSPIException("invalid.number.format", pe);
            }
            vsMB.setRequestBean(requestMB);
        }
        if ((nodeCount = (profileNodeList = ((Element)node).getElementsByTagName("profile-bucket")).getLength()) > 0) {
            for (int k = 0; k < nodeCount; ++k) {
                ProfileMB profileMB = new ProfileMB();
                Node profileNode = profileNodeList.item(k);
                try {
                    this.populateProfileMB(profileMB, profileNode);
                    profileMB.setUpdateTime(this._initTreeTime);
                }
                catch (NumberFormatException nfe) {
                    throw new HttpServiceSPIException("invalid.number.format", nfe);
                }
                vsMB.addProfile(profileMB);
            }
        }
    }

    private void updateHttpServiceMB(HttpServiceMB httpServiceMB, Node hsNode) throws HttpServiceSPIException {
        httpServiceMB.setUpdateTime(this._updateTreeTime);
        try {
            this.populateHSMBeanAttributes(httpServiceMB, hsNode);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        catch (ParseException pe) {
            throw new HttpServiceSPIException("invalid.number.format", pe);
        }
        Element hsElement = (Element)hsNode;
        Node processNode = hsElement.getElementsByTagName("process").item(0);
        this.updateProcessMBeans(httpServiceMB, processNode);
        NodeList vsNodeList = hsElement.getElementsByTagName("virtual-server");
        this.updateVSMBeans(httpServiceMB, vsNodeList);
    }

    private void updateProcessMBeans(HttpServiceMB httpServiceMB, Node processNode) throws HttpServiceSPIException {
        NodeList processNodeList = processNode.getChildNodes();
        for (int i = 0; i < processNodeList.getLength(); ++i) {
            String name = processNodeList.item(i).getNodeName();
            if (name.equals("connection-queue-bucket") && !this.updateConnQueueStatus) {
                this.updateConnectionQueueMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (name.equals("thread-pool-bucket") && !this.updateThreadPoolStatus) {
                this.updateThreadPoolMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (name.equals("dns-bucket")) {
                this.updateDnsMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (name.equals("keepalive-bucket")) {
                this.updateKeepAliveMB(httpServiceMB, processNodeList.item(i));
                continue;
            }
            if (!name.equals("cache-bucket")) continue;
            this.updateFileCacheMB(httpServiceMB, processNodeList.item(i));
        }
    }

    private void updateConnectionQueueMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        ConnectionQueueMB connQueueMB = httpServiceMB.getConnectionQueueBean();
        connQueueMB.setUpdateTime(this._updateTreeTime);
        try {
            this.populateConnectionQueueMB(connQueueMB, node);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        catch (ParseException pe) {
            throw new HttpServiceSPIException("invalid.number.format", pe);
        }
        this.updateConnQueueStatus = true;
    }

    private void updateThreadPoolMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        ThreadPoolMB threadPoolMB = httpServiceMB.getThreadPoolBean();
        threadPoolMB.setUpdateTime(this._updateTreeTime);
        try {
            this.populateThreadPoolMB(threadPoolMB, node);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
        this.updateThreadPoolStatus = true;
    }

    private void updateDnsMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        DnsMB dnsMB = httpServiceMB.getDnsBean();
        dnsMB.setUpdateTime(this._updateTreeTime);
        try {
            this.populateDnsMB(dnsMB, node);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
    }

    private void updateKeepAliveMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        KeepAliveMB keepAliveMB = httpServiceMB.getKeepAliveBean();
        keepAliveMB.setUpdateTime(this._updateTreeTime);
        try {
            this.populateKeepAliveMB(keepAliveMB, node);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
    }

    private void updateFileCacheMB(HttpServiceMB httpServiceMB, Node node) throws HttpServiceSPIException {
        FileCacheMB fileCacheMB = httpServiceMB.getFileCacheBean();
        fileCacheMB.setUpdateTime(this._updateTreeTime);
        try {
            this.populateFileCacheMB(fileCacheMB, node);
        }
        catch (NumberFormatException nfe) {
            throw new HttpServiceSPIException("invalid.number.format", nfe);
        }
    }

    private void updateVSMBeans(HttpServiceMB httpServiceMB, NodeList vsNodeList) throws HttpServiceSPIException {
        List vsList;
        VirtualServerMB virtualServerMB = null;
        int vsCount = vsNodeList.getLength();
        if (vsCount != (vsList = httpServiceMB.getVirtualServers()).size()) {
            HttpServiceLogger.log(0, "httpservice.monitor.unmarshaller.vs_differ");
        }
        for (int j = 0; j < vsCount; ++j) {
            Node node = vsNodeList.item(j);
            String id = node.getAttributes().getNamedItem("id").getNodeValue();
            virtualServerMB = httpServiceMB.getVirtualServerByID(id);
            virtualServerMB.setUpdateTime(this._updateTreeTime);
            this.updateVirtualServerMBTree(virtualServerMB, node);
        }
    }

    private void updateVirtualServerMBTree(VirtualServerMB vsMB, Node node) throws HttpServiceSPIException {
        List profileList;
        int profileCount;
        NodeList profileNodeList;
        int nodeCount;
        this.populateVSMBeanAttributes(vsMB, node);
        NodeList reqNodeList = ((Element)node).getElementsByTagName("request-bucket");
        if (reqNodeList.getLength() > 0) {
            Node reqNode = reqNodeList.item(0);
            RequestMB requestMB = vsMB.getRequestBean();
            requestMB.setUpdateTime(this._updateTreeTime);
            try {
                this.populateRequestMB(requestMB, reqNode);
            }
            catch (NumberFormatException nfe) {
                throw new HttpServiceSPIException("invalid.number.format", nfe);
            }
            catch (ParseException pe) {
                throw new HttpServiceSPIException("invalid.number.format", pe);
            }
        }
        if ((nodeCount = (profileNodeList = ((Element)node).getElementsByTagName("profile-bucket")).getLength()) != (profileCount = (profileList = vsMB.getProfileList()).size())) {
            HttpServiceLogger.log(0, "httpservice.monitor.unmarshaller.vs_profilers_differ");
        }
        if (nodeCount > 0) {
            for (int k = 0; k < nodeCount; ++k) {
                Node profileNode = profileNodeList.item(k);
                String id = profileNode.getAttributes().getNamedItem("profile").getNodeValue();
                ProfileMB profileMB = vsMB.getProfileByID(id);
                profileMB.setUpdateTime(this._updateTreeTime);
                if (profileMB == null) continue;
                try {
                    this.populateProfileMB(profileMB, profileNode);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new HttpServiceSPIException("invalid.number.format", nfe);
                }
            }
        }
    }

    private void populateConnectionQueueMB(ConnectionQueueMB connQueueMB, Node node) throws ParseException {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("connection-queue");
        if (attrNode != null) {
            connQueueMB.setId(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("countTotalConnections")) != null) {
            connQueueMB.setCountTotalConnections(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countQueued")) != null) {
            connQueueMB.setCountQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("peakQueued")) != null) {
            connQueueMB.setPeakQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxQueued")) != null) {
            connQueueMB.setMaxQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countOverflows")) != null) {
            connQueueMB.setCountOverflows(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countTotalQueued")) != null) {
            connQueueMB.setCountTotalQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("ticksTotalQueued")) != null) {
            connQueueMB.setTicksTotalQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countQueued1MinuteAverage")) != null) {
            connQueueMB.setCountQueued1MinuteAverage(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("countQueued5MinuteAverage")) != null) {
            connQueueMB.setCountQueued5MinuteAverage(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("countQueued15MinuteAverage")) != null) {
            connQueueMB.setCountQueued15MinuteAverage(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
    }

    private void populateThreadPoolMB(ThreadPoolMB threadPoolMB, Node node) {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("thread-pool");
        if (attrNode != null) {
            threadPoolMB.setId(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("countThreadsIdle")) != null) {
            threadPoolMB.setCountThreadsIdle(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countThreads")) != null) {
            threadPoolMB.setCountThreads(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxThreads")) != null) {
            threadPoolMB.setMaxThreads(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countQueued")) != null) {
            threadPoolMB.setCountQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("peakQueued")) != null) {
            threadPoolMB.setPeakQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxQueued")) != null) {
            threadPoolMB.setMaxQueued(Integer.parseInt(attrNode.getNodeValue()));
        }
    }

    private void populateDnsMB(DnsMB dnsMB, Node node) {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("flagCacheEnabled");
        if (attrNode != null) {
            dnsMB.setFlagCacheEnabled(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countCacheEntries")) != null) {
            dnsMB.setCountCacheEntries(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxCacheEntries")) != null) {
            dnsMB.setMaxCacheEntries(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countCacheHits")) != null) {
            dnsMB.setCountCacheHits(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countCacheMisses")) != null) {
            dnsMB.setCountCacheMisses(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("flagAsyncEnabled")) != null) {
            dnsMB.setFlagAsyncEnabled(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countAsyncNameLookups")) != null) {
            dnsMB.setCountAsyncNameLookups(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countAsyncAddrLookups")) != null) {
            dnsMB.setCountAsyncAddrLookups(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countAsyncLookupsInProgress")) != null) {
            dnsMB.setCountAsyncLookupsInProgress(Integer.parseInt(attrNode.getNodeValue()));
        }
    }

    private void populateKeepAliveMB(KeepAliveMB keepAliveMB, Node node) {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("countConnections");
        if (attrNode != null) {
            keepAliveMB.setCountConnections(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxConnections")) != null) {
            keepAliveMB.setMaxConnections(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countHits")) != null) {
            keepAliveMB.setCountHits(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countFlushes")) != null) {
            keepAliveMB.setCountFlushes(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countRefusals")) != null) {
            keepAliveMB.setCountRefusals(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countTimeouts")) != null) {
            keepAliveMB.setCountTimeouts(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("secondsTimeout")) != null) {
            keepAliveMB.setSecondsTimeout(Long.parseLong(attrNode.getNodeValue()));
        }
    }

    private void populateFileCacheMB(FileCacheMB fileCacheMB, Node node) {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("flagEnabled");
        if (attrNode != null) {
            fileCacheMB.setFlagEnabled(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("secondsMaxAge")) != null) {
            fileCacheMB.setSecondsMaxAge(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countEntries")) != null) {
            fileCacheMB.setCountEntries(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxEntries")) != null) {
            fileCacheMB.setMaxEntries(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countOpenEntries")) != null) {
            fileCacheMB.setCountOpenEntries(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxOpenEntries")) != null) {
            fileCacheMB.setMaxOpenEntries(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("sizeHeapCache")) != null) {
            fileCacheMB.setSizeHeapCache(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxHeapCacheSize")) != null) {
            fileCacheMB.setMaxHeapCacheSize(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("sizeMmapCache")) != null) {
            fileCacheMB.setSizeMmapCache(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxMmapCacheSize")) != null) {
            fileCacheMB.setMaxMmapCacheSize(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countHits")) != null) {
            fileCacheMB.setCountHits(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countMisses")) != null) {
            fileCacheMB.setCountMisses(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countInfoHits")) != null) {
            fileCacheMB.setCountInfoHits(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countInfoMisses")) != null) {
            fileCacheMB.setCountInfoMisses(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countContentHits")) != null) {
            fileCacheMB.setCountContentHits(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countContentMisses")) != null) {
            fileCacheMB.setCountContentMisses(Integer.parseInt(attrNode.getNodeValue()));
        }
    }

    private void populateVSMBeanAttributes(VirtualServerMB vsMB, Node node) {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("id");
        if (attrNode != null) {
            vsMB.setId(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("mode")) != null) {
            vsMB.setMode(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("hosts")) != null) {
            vsMB.setHosts(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("interfaces")) != null) {
            vsMB.setInterfaces(attrNode.getNodeValue());
        }
    }

    private void populateRequestMB(RequestMB requestMB, Node node) throws ParseException {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("method");
        if (attrNode != null) {
            requestMB.setMethod(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("uri")) != null) {
            requestMB.setUri(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("countRequests")) != null) {
            requestMB.setCountRequests(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countBytesReceived")) != null) {
            requestMB.setCountBytesReceived(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countBytesTransmitted")) != null) {
            requestMB.setCountBytesTransmitted(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("rateBytesTransmitted")) != null) {
            requestMB.setRateBytesTransmitted(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("maxByteTransmissionRate")) != null) {
            requestMB.setMaxByteTransmissionRate(Float.parseFloat(this.numberFormat.parse(attrNode.getNodeValue()).toString()));
        }
        if ((attrNode = nnm.getNamedItem("countOpenConnections")) != null) {
            requestMB.setCountOpenConnections(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("maxOpenConnections")) != null) {
            requestMB.setMaxOpenConnections(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count2xx")) != null) {
            requestMB.setCount2xx(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count3xx")) != null) {
            requestMB.setCount3xx(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count4xx")) != null) {
            requestMB.setCount4xx(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count5xx")) != null) {
            requestMB.setCount5xx(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countOther")) != null) {
            requestMB.setCountOther(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count200")) != null) {
            requestMB.setCount200(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count302")) != null) {
            requestMB.setCount302(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count304")) != null) {
            requestMB.setCount304(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count400")) != null) {
            requestMB.setCount400(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count401")) != null) {
            requestMB.setCount401(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count403")) != null) {
            requestMB.setCount403(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count404")) != null) {
            requestMB.setCount404(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("count503")) != null) {
            requestMB.setCount503(Integer.parseInt(attrNode.getNodeValue()));
        }
    }

    private void populateProfileMB(ProfileMB profileMB, Node node) {
        Node attrNode = null;
        NamedNodeMap nnm = node.getAttributes();
        attrNode = nnm.getNamedItem("profile");
        if (attrNode != null) {
            profileMB.setId(attrNode.getNodeValue());
        }
        if ((attrNode = nnm.getNamedItem("countCalls")) != null) {
            profileMB.setCountCalls(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("countRequests")) != null) {
            profileMB.setCountRequests(Integer.parseInt(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("ticksDispatch")) != null) {
            profileMB.setTicksDispatch(Long.parseLong(attrNode.getNodeValue()));
        }
        if ((attrNode = nnm.getNamedItem("ticksFunction")) != null) {
            profileMB.setTicksFunction(Long.parseLong(attrNode.getNodeValue()));
        }
    }

    private String trimXml(String statsXmlData) throws HttpServiceSPIException {
        String trimmedXml = null;
        StringBuffer strBuffer = new StringBuffer(statsXmlData);
        int statsStart = strBuffer.indexOf("<stats ");
        int statsEnd = strBuffer.indexOf("</stats>");
        try {
            trimmedXml = strBuffer.substring(statsStart, statsEnd + 8);
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new HttpServiceSPIException("httpservice.monitoring.statsxml.retrieval.failed", ex);
        }
        return trimmedXml;
    }

    private Document parseStatsXml(String statsXmlData) throws HttpServiceSPIException {
        Document doc = null;
        statsXmlData = this.trimXml(statsXmlData);
        ByteArrayInputStream statsXmlInputStream = new ByteArrayInputStream(statsXmlData.getBytes());
        try {
            doc = this.docBuilder.parse(statsXmlInputStream);
        }
        catch (SAXException ex) {
            throw new HttpServiceSPIException("httpservice.monitoring.parse.failed", ex);
        }
        catch (IOException ex) {
            throw new HttpServiceSPIException("httpservice.monitoring.parse.failed", ex);
        }
        return doc;
    }
}

