/*
 * Decompiled with CFR 0.152.
 */
package com.sun.httpservice.spi;

import com.sun.httpservice.spi.FileCacheConfig;
import com.sun.httpservice.spi.HttpServiceConfig;
import com.sun.httpservice.spi.HttpServiceEvent;
import com.sun.httpservice.spi.HttpServiceEventListener;
import com.sun.httpservice.spi.HttpServiceLogRotator;
import com.sun.httpservice.spi.HttpServiceNSSPinProvider;
import com.sun.httpservice.spi.HttpServiceSPIException;
import com.sun.httpservice.spi.ListenSocketConfig;
import com.sun.httpservice.spi.MagnusConfig;
import com.sun.httpservice.spi.MagnusDirective;
import com.sun.httpservice.spi.SSLServerConfig;
import com.sun.httpservice.spi.VSDefaultTypeConfig;
import com.sun.httpservice.spi.VSForceTypeConfig;
import com.sun.httpservice.spi.VirtualServerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HttpService {
    public static final int SERVICE_INITIALIZED = 0;
    public static final int SERVICE_STARTED = 1;
    public static final int SERVICE_RECONFIG = 2;
    public static final int SERVICE_STOPPED = 3;
    private ArrayList eventListenerList;
    private byte[] listenerListLock = new byte[0];
    private static final int STATUS_NEW = 0;
    private static final int STATUS_INITIALIZED = 1;
    private static final int STATUS_RUNNING = 2;
    private static final int STATUS_STOPPED = 3;
    private int status = 0;
    private static HttpServiceNSSPinProvider _pin_provider;
    private HttpServiceLogRotator logRotator;
    private byte[] rotatorLock = new byte[0];
    private static HttpService httpService;

    private native void httpservice_preinit() throws HttpServiceSPIException;

    private native void httpservice_init(long var1) throws HttpServiceSPIException;

    private native void httpservice_run() throws HttpServiceSPIException;

    private native void httpservice_reconfig(long var1) throws HttpServiceSPIException;

    private native void httpservice_stop() throws HttpServiceSPIException;

    private native void configure_file_cache_config(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int[] var13) throws HttpServiceSPIException;

    private native void set_magnus_configuration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int[] var12) throws HttpServiceSPIException;

    private native long add_virtual_server_config(long var1, String var3, String var4, String var5, String var6, int var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, int[] var17, int[] var18, int[] var19) throws HttpServiceSPIException;

    private native void set_ssl_server_config(long var1, String var3, int var4, int var5, int var6, String var7, String var8, int var9, int var10, int[] var11) throws HttpServiceSPIException;

    private native long add_listen_socket_config(long var1, String var3, int var4, String var5, String var6, String var7, String var8, int var9, int var10, int var11, int var12, int var13, int[] var14) throws HttpServiceSPIException;

    private native long create_httpservice_config(String var1, String var2, int var3, String var4, int[] var5) throws HttpServiceSPIException;

    private native void configure_only_once(String var1, String var2, String var3, String var4, String var5, int var6, int[] var7) throws HttpServiceSPIException;

    private native void virtual_socket_config_add_listen_socket(long var1, String var3) throws HttpServiceSPIException;

    private native void httpservice_config_set_magnus_directive(long var1, String var3, String var4) throws HttpServiceSPIException;

    private native String httpservice_get_stats();

    private HttpService() {
    }

    public static synchronized HttpService getInstance() {
        if (httpService == null) {
            httpService = new HttpService();
        }
        return httpService;
    }

    public synchronized void init(HttpServiceConfig hsc) throws HttpServiceSPIException {
        if (this.status != 0) {
            throw new HttpServiceSPIException("Illegal state, cannot perform call");
        }
        this.httpservice_preinit();
        this.configureOnlyOnce(hsc);
        long _service_p = this.configure_service(hsc);
        this.httpservice_init(_service_p);
        this.status = 1;
        this.notifyListeners(0, null);
    }

    public synchronized void run() throws HttpServiceSPIException {
        if (this.status != 1) {
            throw new HttpServiceSPIException("Illegal state, cannot perform call");
        }
        this.httpservice_run();
        this.status = 2;
        this.notifyListeners(1, null);
    }

    public synchronized void reconfig(HttpServiceConfig hsc) throws HttpServiceSPIException {
        if (this.status != 2) {
            throw new HttpServiceSPIException("Illegal state, cannot perform call");
        }
        long _service_p = this.configure_service(hsc);
        this.httpservice_reconfig(_service_p);
        this.status = 2;
        this.notifyListeners(2, null);
    }

    public synchronized void stop() throws HttpServiceSPIException {
        if (this.status != 2) {
            throw new HttpServiceSPIException("Illegal state, cannot perform call");
        }
        this.httpservice_stop();
        this.status = 3;
        this.notifyListeners(3, null);
    }

    private long configure_service(HttpServiceConfig httpServiceConfig) throws HttpServiceSPIException {
        MagnusConfig mc;
        long service_p = 0L;
        this.validateHSConfigFields(httpServiceConfig);
        service_p = this.create_httpservice_config(httpServiceConfig.getServerName(), httpServiceConfig.getDefaultLang(), httpServiceConfig.getLogLevel(), httpServiceConfig.getAccessLogFormat(), httpServiceConfig.getDirtyArray());
        HashMap<String, Long> lsMap = new HashMap<String, Long>();
        List lsList = httpServiceConfig.getListeningSocket();
        if (lsList == null) {
            throw new HttpServiceSPIException("getListeningSocket() returned null");
        }
        Iterator lsIterator = lsList.iterator();
        while (lsIterator.hasNext()) {
            ListenSocketConfig lsc = (ListenSocketConfig)lsIterator.next();
            if (lsc == null) {
                throw new HttpServiceSPIException("ListenSocketConfig object is null");
            }
            String lsId = lsc.getId();
            this.validateLSConfigFields(lsc);
            long ls_p = this.add_listen_socket_config(service_p, lsc.getId(), lsc.getListenPort(), lsc.getDefaultVSId(), lsc.getIp(), lsc.getServerName(), lsc.getFamily(), lsc.isSecure() ? 1 : 0, lsc.getListenPort(), lsc.getExternalPort(), lsc.getAcceptorThreads(), lsc.isBlocking() ? 1 : 0, lsc.getDirtyArray());
            if (lsMap.containsKey(lsId)) {
                throw new HttpServiceSPIException("Listen socket ID already exists " + lsId);
            }
            lsMap.put(lsId, new Long(ls_p));
            SSLServerConfig sslc = lsc.getSSLServerConfig();
            if (sslc == null) continue;
            this.set_ssl_server_config(ls_p, sslc.getServerNickname(), sslc.isSsl2() ? 1 : 0, sslc.isSsl3() ? 1 : 0, sslc.isTls() ? 1 : 0, sslc.getSsl2Ciphers(), sslc.getSsl3TlsCiphers(), sslc.isTlsRollback() ? 1 : 0, sslc.isClientAuth() ? 1 : 0, sslc.getDirtyArray());
        }
        List vsList = httpServiceConfig.getVirtualServer();
        if (vsList == null) {
            throw new HttpServiceSPIException("getVirtualServer() returned null");
        }
        Iterator vs_it = vsList.iterator();
        while (vs_it.hasNext()) {
            VirtualServerConfig vsc = (VirtualServerConfig)vs_it.next();
            if (vsc == null) {
                throw new HttpServiceSPIException("VirtualServerConfig object is null");
            }
            this.validateVSConfigFields(vsc);
            int[] vscDirtyArray = vsc.getDirtyArray();
            boolean defaultTypeSet = false;
            boolean forceTypeSet = false;
            int[] dummydtArray = new int[]{0, 0, 0, 0};
            int[] dummyftArray = new int[]{0, 0, 0, 0, 0};
            VSDefaultTypeConfig defaultType = null;
            VSForceTypeConfig forceType = null;
            if (vscDirtyArray[5] == 1) {
                defaultTypeSet = true;
                defaultType = vsc.getDefaultType();
            }
            if (vscDirtyArray[6] == 1) {
                forceTypeSet = true;
                forceType = vsc.getForceType();
            }
            long vs_p = this.add_virtual_server_config(service_p, vsc.getId(), vsc.getDocRoot(), vsc.getUrlHosts(), vsc.getAccessLog(), vsc.isStateEnable() ? 1 : 0, defaultTypeSet ? defaultType.getEncoding() : null, defaultTypeSet ? defaultType.getLang() : null, defaultTypeSet ? defaultType.getCharset() : null, defaultTypeSet ? defaultType.getBucket() : null, forceTypeSet ? forceType.getType() : null, forceTypeSet ? forceType.getEncoding() : null, forceTypeSet ? forceType.getLang() : null, forceTypeSet ? forceType.getCharset() : null, forceTypeSet ? forceType.getBucket() : null, defaultTypeSet ? defaultType.getDirtyArray() : dummydtArray, forceTypeSet ? forceType.getDirtyArray() : dummyftArray, vsc.getDirtyArray());
            if (vsc.getListenSockets() == null) continue;
            Iterator vs_ls_it = vsc.getListenSockets().iterator();
            while (vs_ls_it.hasNext()) {
                String vs_lsId = (String)vs_ls_it.next();
                if (lsMap.containsKey(vs_lsId)) {
                    this.virtual_socket_config_add_listen_socket(vs_p, vs_lsId);
                    continue;
                }
                throw new HttpServiceSPIException("Listening socket has not been configured!:" + vs_lsId);
            }
        }
        FileCacheConfig fcc = httpServiceConfig.getFileCacheConfig();
        if (fcc != null) {
            this.configure_file_cache_config(service_p, fcc.isEnable() ? 1 : 0, fcc.isCacheFileContentEnable() ? 1 : 0, fcc.getMaxAge(), fcc.getMaxFiles(), fcc.getMediumFileSizeLimit(), fcc.getMediumFileSpace(), fcc.getSmallFileSizeLimit(), fcc.getSmallFileSpace(), fcc.getHashInitSize(), fcc.isTransmitFile() ? 1 : 0, fcc.getDirtyArray());
        }
        if ((mc = httpServiceConfig.getMagnusConfig()) != null) {
            this.set_magnus_configuration(service_p, mc.getConnQueueSize(), mc.getDnsEnable() ? 1 : 0, mc.getIoTimeout(), mc.getListenQ(), mc.getMaxKeepaliveConnections(), mc.getRcvBufSize(), mc.getRqThrottle(), mc.getRqThrottleMin(), mc.getSecurityEnable() ? 1 : 0, mc.getDirtyArray());
            List directivesList = mc.getMagnusDirectives();
            if (directivesList != null) {
                MagnusDirective directive = null;
                Iterator directiveIt = null;
                directiveIt = mc.getMagnusDirectives().iterator();
                while (directiveIt.hasNext()) {
                    directive = (MagnusDirective)directiveIt.next();
                    this.httpservice_config_set_magnus_directive(service_p, directive.getName(), directive.getValue());
                }
            }
        }
        return service_p;
    }

    private void configureOnlyOnce(HttpServiceConfig httpServiceConfig) throws HttpServiceSPIException {
        this.validateHSConfigOnlyOnceFields(httpServiceConfig);
        this.configure_only_once(httpServiceConfig.getInstallDirectory(), httpServiceConfig.getInstanceDirectory(), httpServiceConfig.getCertificateDirectory(), httpServiceConfig.getTempDir(), httpServiceConfig.getResourceDir(), httpServiceConfig.getSkipNSSInitialize() ? 1 : 0, httpServiceConfig.getDirtyArray());
    }

    public static String getNSSPin(String token) {
        if (_pin_provider == null) {
            return null;
        }
        return _pin_provider.getNSSPin(token);
    }

    public static void setNSSPinProvider(HttpServiceNSSPinProvider pp) {
        _pin_provider = pp;
    }

    private void validateHSConfigOnlyOnceFields(HttpServiceConfig httpServiceConfig) throws HttpServiceSPIException {
        int[] dirtyArray = httpServiceConfig.getDirtyArray();
        if (dirtyArray[0] != 1) {
            throw new HttpServiceSPIException("Install directory not set");
        }
        if (dirtyArray[1] != 1) {
            throw new HttpServiceSPIException("Instance directory not set");
        }
        if (dirtyArray[6] != 1) {
            throw new HttpServiceSPIException("Temp dir not set");
        }
        if (dirtyArray[8] != 1) {
            throw new HttpServiceSPIException("Resource dir not set");
        }
    }

    private void validateHSConfigFields(HttpServiceConfig httpServiceConfig) throws HttpServiceSPIException {
        int[] dirtyArray = httpServiceConfig.getDirtyArray();
        if (dirtyArray[3] != 1) {
            throw new HttpServiceSPIException("Server name not set");
        }
        if (dirtyArray[4] != 1) {
            throw new HttpServiceSPIException("Default Language not set");
        }
    }

    private void validateLSConfigFields(ListenSocketConfig listenSocketConfig) throws HttpServiceSPIException {
        int[] dirtyArray = listenSocketConfig.getDirtyArray();
        if (dirtyArray[5] != 1) {
            throw new HttpServiceSPIException("Listen Port not set");
        }
        if (dirtyArray[2] != 1) {
            throw new HttpServiceSPIException("Server name not set");
        }
        if (dirtyArray[9] != 1) {
            throw new HttpServiceSPIException("Default VS ID not set");
        }
    }

    private void validateVSConfigFields(VirtualServerConfig virtualServerConfig) throws HttpServiceSPIException {
        int[] dirtyArray = virtualServerConfig.getDirtyArray();
        if (dirtyArray[2] != 1) {
            throw new HttpServiceSPIException("DocRoot not set");
        }
        if (dirtyArray[1] != 1) {
            throw new HttpServiceSPIException("UrlHosts not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(HttpServiceEventListener listener) {
        byte[] byArray = this.listenerListLock;
        synchronized (this.listenerListLock) {
            if (this.eventListenerList == null) {
                this.eventListenerList = new ArrayList();
            }
            if (this.eventListenerList.contains(listener)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.eventListenerList.add(listener);
            this.eventListenerList.trimToSize();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HttpServiceEventListener listener) {
        byte[] byArray = this.listenerListLock;
        synchronized (this.listenerListLock) {
            if (this.eventListenerList == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.eventListenerList.remove(listener);
            this.eventListenerList.trimToSize();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int type, Object data) {
        byte[] byArray = this.listenerListLock;
        synchronized (this.listenerListLock) {
            if (this.eventListenerList == null || this.eventListenerList.size() < 1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            HttpServiceEvent evt = new HttpServiceEvent(this, type, data);
            HttpServiceEventListener listener = null;
            Iterator it = this.eventListenerList.iterator();
            while (it.hasNext()) {
                listener = (HttpServiceEventListener)it.next();
                listener.httpServiceEvent(evt);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public synchronized String getMonitoringStats() throws HttpServiceSPIException {
        if (this.status != 2) {
            throw new HttpServiceSPIException("Illegal state, cannot perform call");
        }
        String s = this.httpservice_get_stats();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServiceLogRotator getLogRotator() {
        byte[] byArray = this.rotatorLock;
        synchronized (this.rotatorLock) {
            if (this.logRotator == null) {
                this.logRotator = new HttpServiceLogRotator();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.logRotator;
        }
    }

    static {
        System.loadLibrary("httpservicespi");
        _pin_provider = null;
    }
}

