/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class ReaderInputStream
extends InputStream {
    private Reader _reader = null;
    private CharsetEncoder _charsetEncoder = null;

    public ReaderInputStream(Reader reader) {
        this._reader = reader;
    }

    public ReaderInputStream(Reader reader, String charsetName) {
        this._reader = reader;
        Charset charset = Charset.forName(charsetName);
        this._charsetEncoder = charset != null ? charset.newEncoder() : null;
    }

    public ReaderInputStream(Reader reader, CharsetEncoder charsetEncoder) {
        this._reader = reader;
        this._charsetEncoder = charsetEncoder;
    }

    public int read() throws IOException {
        int r = this._reader.read();
        if (r == -1) {
            return -1;
        }
        char[] ca = new char[]{(char)r};
        if (this._charsetEncoder == null) {
            String s = new String(ca);
            byte[] ba = s.getBytes();
            return ba[0];
        }
        ByteBuffer b = this.encode(ca);
        return b.get(0);
    }

    private ByteBuffer encode(char[] ca) throws IOException {
        CharBuffer c = CharBuffer.wrap(ca);
        this._charsetEncoder.reset();
        ByteBuffer b = null;
        try {
            b = this._charsetEncoder.encode(c);
        }
        catch (CharacterCodingException e) {
            throw new IOException(e.getMessage());
        }
        return b;
    }
}

