/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import com.sun.enterprise.util.logging.IASLevel;
import com.sun.httpservice.spi.LogListener;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpServiceLogListener
implements LogListener {
    private static Logger _logger = null;

    public HttpServiceLogListener() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public void log(int nsapiLevel, String msg) {
        Level level = this.getLevelFromNativeLevel(nsapiLevel);
        _logger.log(level, msg);
    }

    public void log(int nsapiLevel, String msg, Throwable t) {
        Level level = this.getLevelFromNativeLevel(nsapiLevel);
        _logger.log(level, msg, t);
    }

    public void log(int nsapiLevel, String msg, Object[] params) {
        Level level = this.getLevelFromNativeLevel(nsapiLevel);
        _logger.log(level, msg, params);
    }

    private Level getLevelFromNativeLevel(int nsapiLevel) {
        Level level = Level.FINEST;
        switch (nsapiLevel) {
            case 0: {
                level = Level.WARNING;
                break;
            }
            case 1: 
            case 3: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = IASLevel.ALERT;
                break;
            }
            case 4: {
                level = IASLevel.FATAL;
                break;
            }
            case 5: {
                level = Level.INFO;
                break;
            }
            case 6: {
                level = Level.FINE;
                break;
            }
            case 7: {
                level = Level.FINER;
                break;
            }
            case 8: {
                level = Level.FINEST;
            }
        }
        return level;
    }
}

