/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.monitor.beans;

import com.sun.enterprise.server.monitor.beans.ServerMonitorBean;
import com.sun.enterprise.server.monitor.beans.SunBaseMonitorBean;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class StatsMonitorBean
extends SunBaseMonitorBean {
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    static Vector comparators = new Vector();
    public static final String SERVER = "Server";

    public StatsMonitorBean() {
        this(null, Common.USE_DEFAULT_VALUES);
    }

    public StatsMonitorBean(Node doc, int options) {
        this(Common.NO_DEFAULT_VALUES);
        try {
            this.initFromNode(doc, options);
        }
        catch (Schema2BeansException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "monitor.exception", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void initFromNode(Node doc, int options) throws Schema2BeansException {
        if (doc == null && (doc = GraphManager.createRootElementNode((String)"stats")) == null) {
            throw new Schema2BeansException(Common.getMessage((String)"CantCreateDOMRoot_msg", (Object)"stats"));
        }
        Node n = GraphManager.getElementNode((String)"stats", (Node)doc);
        if (n == null) {
            throw new Schema2BeansException(Common.getMessage((String)"DocRootNotInDOMGraph_msg", (Object)"stats", (Object)doc.getFirstChild().getNodeName()));
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public StatsMonitorBean(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.initOptions(options);
    }

    protected void initOptions(int options) {
        this.graphManager = new GraphManager((BaseBean)this);
        this.createRoot("stats", "Stats", 544, StatsMonitorBean.class);
        this.createProperty("server", SERVER, 66096, ServerMonitorBean.class);
        this.createAttribute(SERVER, "id", "Id", 260, null, null);
        this.createAttribute(SERVER, "versionServer", "VersionServer", 257, null, null);
        this.createAttribute(SERVER, "timeStarted", "TimeStarted", 257, null, null);
        this.createAttribute(SERVER, "secondsRunning", "SecondsRunning", 257, null, null);
        this.createAttribute(SERVER, "ticksPerSecond", "TicksPerSecond", 257, null, null);
        this.createAttribute(SERVER, "maxProcs", "MaxProcs", 257, null, null);
        this.createAttribute(SERVER, "maxThreads", "MaxThreads", 257, null, null);
        this.createAttribute(SERVER, "maxVirtualServers", "MaxVirtualServers", 257, null, null);
        this.createAttribute(SERVER, "flagProfilingEnabled", "FlagProfilingEnabled", 258, new String[]{"0", "1"}, null);
        this.createAttribute(SERVER, "flagVirtualServerOverflow", "FlagVirtualServerOverflow", 258, new String[]{"0", "1"}, null);
        this.createAttribute("enabled", "Enabled", 258, new String[]{"0", "1"}, null);
        this.createAttribute("versionMajor", "VersionMajor", 769, null, "1");
        this.createAttribute("versionMinor", "VersionMinor", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setServer(int index, ServerMonitorBean value) {
        this.setValue(SERVER, index, (Object)value);
    }

    public ServerMonitorBean getServer(int index) {
        return (ServerMonitorBean)((Object)this.getValue(SERVER, index));
    }

    public void setServer(ServerMonitorBean[] value) {
        this.setValue(SERVER, (Object[])value);
    }

    public ServerMonitorBean[] getServer() {
        return (ServerMonitorBean[])this.getValues(SERVER);
    }

    public int sizeServer() {
        return this.size(SERVER);
    }

    public int addServer(ServerMonitorBean value) {
        return this.addValue(SERVER, (Object)value);
    }

    public int removeServer(ServerMonitorBean value) {
        return this.removeValue(SERVER, (Object)value);
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static StatsMonitorBean createGraph(Node doc) {
        return new StatsMonitorBean(doc, Common.NO_DEFAULT_VALUES);
    }

    public static StatsMonitorBean createGraph(InputStream in) {
        return StatsMonitorBean.createGraph(in, false);
    }

    public static StatsMonitorBean createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate);
            return StatsMonitorBean.createGraph(doc);
        }
        catch (Exception t) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "monitor.exception", t);
            }
            throw new RuntimeException(Common.getMessage((String)"DOMGraphCreateFailed_msg", (Object)t.getMessage()));
        }
    }

    public static StatsMonitorBean createGraph(InputStream in, boolean validate, EntityResolver er) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate, (EntityResolver)er);
            return StatsMonitorBean.createGraph(doc);
        }
        catch (Exception t) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "monitor.exception", t);
            }
            throw new RuntimeException(Common.getMessage((String)"DOMGraphCreateFailed_msg", (Object)t.getMessage()));
        }
    }

    public static StatsMonitorBean createGraph(InputSource in, boolean validate, EntityResolver er) {
        try {
            Document doc = GraphManager.createXmlDocument((InputSource)in, (boolean)validate, (EntityResolver)er, null);
            return StatsMonitorBean.createGraph(doc);
        }
        catch (Exception t) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "monitor.exception", t);
            }
            throw new RuntimeException(Common.getMessage((String)"DOMGraphCreateFailed_msg", (Object)t.getMessage()));
        }
    }

    public static StatsMonitorBean createGraph() {
        return new StatsMonitorBean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        String str = baos.toString();
        out.writeUTF(str);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.init(comparators, new GenBeans.Version(1, 0, 8));
            String strDocument = in.readUTF();
            ByteArrayInputStream bais = new ByteArrayInputStream(strDocument.getBytes());
            Document doc = GraphManager.createXmlDocument((InputStream)bais, (boolean)false);
            this.initOptions(Common.NO_DEFAULT_VALUES);
            this.initFromNode(doc, Common.NO_DEFAULT_VALUES);
        }
        catch (Schema2BeansException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "monitor.exception", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public void dump(StringBuffer str, String indent) {
        String fourSpaces = "    ";
        str.append(indent);
        str.append("Number of Servers = " + this.sizeServer());
        for (int i = 0; i < this.sizeServer(); ++i) {
            str.append(indent + fourSpaces);
            str.append("Server #" + (i + 1) + ":");
            ServerMonitorBean n = this.getServer(i);
            if (n != null) {
                n.dump(str, indent + fourSpaces);
            } else {
                str.append(indent + fourSpaces + "null");
            }
            this.dumpAttributes(SERVER, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("Stats\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

