/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCFileCacheStats;
import com.sun.httpservice.spi.monitor.FileCacheMB;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCFileCacheStatsImpl
implements PWCFileCacheStats {
    static Logger _logger = null;
    private FileCacheMB _bean;
    private long _startTime;
    private GenericStatsImpl _gsImpl;
    private MutableCountStatistic _flagEnabled;
    private MutableCountStatistic _secondsMaxAge;
    private MutableCountStatistic _countEntries;
    private MutableCountStatistic _maxEntries;
    private MutableCountStatistic _countOpenEntries;
    private MutableCountStatistic _maxOpenEntries;
    private MutableCountStatistic _sizeHeapCache;
    private MutableCountStatistic _maxHeapCacheSize;
    private MutableCountStatistic _sizeMmapCache;
    private MutableCountStatistic _maxMmapCacheSize;
    private MutableCountStatistic _countHits;
    private MutableCountStatistic _countMisses;
    private MutableCountStatistic _countInfoHits;
    private MutableCountStatistic _countInfoMisses;
    private MutableCountStatistic _countContentHits;
    private MutableCountStatistic _countContentMisses;

    public PWCFileCacheStatsImpl(FileCacheMB bean) {
        this._bean = bean;
        this.initializeStatistics();
        try {
            this._gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "httpservice.monitor.stats.constructor.exception", cnfe);
        }
    }

    public CountStatistic getFlagEnabled() {
        long flagEnabled = this.getBean().getFlagEnabled();
        this._flagEnabled.setCount(flagEnabled);
        return (CountStatistic)this._flagEnabled.unmodifiableView();
    }

    public CountStatistic getSecondsMaxAge() {
        long secondsMaxAge = this.getBean().getSecondsMaxAge();
        this._secondsMaxAge.setCount(secondsMaxAge);
        return (CountStatistic)this._secondsMaxAge.unmodifiableView();
    }

    public CountStatistic getCountEntries() {
        long countEntries = this.getBean().getCountEntries();
        this._countEntries.setCount(countEntries);
        return (CountStatistic)this._countEntries.unmodifiableView();
    }

    public CountStatistic getMaxEntries() {
        long maxEntries = this.getBean().getMaxEntries();
        this._maxEntries.setCount(maxEntries);
        return (CountStatistic)this._maxEntries.unmodifiableView();
    }

    public CountStatistic getCountOpenEntries() {
        long countOpenEntries = this.getBean().getCountOpenEntries();
        this._countOpenEntries.setCount(countOpenEntries);
        return (CountStatistic)this._countOpenEntries.unmodifiableView();
    }

    public CountStatistic getMaxOpenEntries() {
        long maxOpenEntries = this.getBean().getMaxOpenEntries();
        this._maxOpenEntries.setCount(maxOpenEntries);
        return (CountStatistic)this._maxOpenEntries.unmodifiableView();
    }

    public CountStatistic getSizeHeapCache() {
        long sizeHeapCache = this.getBean().getSizeHeapCache();
        this._sizeHeapCache.setCount(sizeHeapCache);
        return (CountStatistic)this._sizeHeapCache.unmodifiableView();
    }

    public CountStatistic getMaxHeapCacheSize() {
        long maxHeapCacheSize = this.getBean().getMaxHeapCacheSize();
        this._maxHeapCacheSize.setCount(maxHeapCacheSize);
        return (CountStatistic)this._maxHeapCacheSize.unmodifiableView();
    }

    public CountStatistic getSizeMmapCache() {
        long sizeMmapCache = this.getBean().getSizeMmapCache();
        this._sizeMmapCache.setCount(sizeMmapCache);
        return (CountStatistic)this._sizeMmapCache.unmodifiableView();
    }

    public CountStatistic getMaxMmapCacheSize() {
        long maxMmapCacheSize = this.getBean().getMaxMmapCacheSize();
        this._maxMmapCacheSize.setCount(maxMmapCacheSize);
        return (CountStatistic)this._maxMmapCacheSize.unmodifiableView();
    }

    public CountStatistic getCountHits() {
        long countHits = this.getBean().getCountHits();
        this._countHits.setCount(countHits);
        return (CountStatistic)this._countHits.unmodifiableView();
    }

    public CountStatistic getCountMisses() {
        long countMisses = this.getBean().getCountMisses();
        this._countMisses.setCount(countMisses);
        return (CountStatistic)this._countMisses.unmodifiableView();
    }

    public CountStatistic getCountInfoHits() {
        long countInfoHits = this.getBean().getCountInfoHits();
        this._countInfoHits.setCount(countInfoHits);
        return (CountStatistic)this._countInfoHits.unmodifiableView();
    }

    public CountStatistic getCountInfoMisses() {
        long countInfoMisses = this.getBean().getCountInfoMisses();
        this._countInfoMisses.setCount(countInfoMisses);
        return (CountStatistic)this._countInfoMisses.unmodifiableView();
    }

    public CountStatistic getCountContentHits() {
        long countContentHits = this.getBean().getCountContentHits();
        this._countContentHits.setCount(countContentHits);
        return (CountStatistic)this._countContentHits.unmodifiableView();
    }

    public CountStatistic getCountContentMisses() {
        long countContentMisses = this.getBean().getCountContentMisses();
        this._countContentMisses.setCount(countContentMisses);
        return (CountStatistic)this._countContentMisses.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this._gsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this._gsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this._gsImpl.getStatisticNames();
    }

    private FileCacheMB getBean() {
        return this._bean;
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "flagEnabled", "(0/1)", "Is file cached enabled?", time, time);
        this._flagEnabled = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "secondsMaxAge", "seconds", "Max age of a cache entry", time, time);
        this._secondsMaxAge = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countEntries", "count", "Number of cache entries", time, time);
        this._countEntries = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxEntries", "count", "Max number of cache entries", time, time);
        this._maxEntries = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countOpenEntries", "count", "Cache entries associated to an open file", time, time);
        this._countOpenEntries = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxOpenEntries", "count", "Max cache entries associated to an open file", time, time);
        this._maxOpenEntries = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "sizeHeapCache", "bytes", "Heap space used for cache content", time, time);
        this._sizeHeapCache = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxHeapCacheSize", "bytes", "Maximum heap space to be used for cache", time, time);
        this._maxHeapCacheSize = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "sizeMmapCache", "bytes", "Address space used by mem mapped file content", time, time);
        this._sizeMmapCache = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxMmapCacheSize", "bytes", "Maximum address space used by mem mapped file content", time, time);
        this._maxMmapCacheSize = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countHits", "count", "Cache lookup hits", time, time);
        this._countHits = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countMisses", "count", "Cache lookup misses", time, time);
        this._countMisses = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countInfoHits", "count", "Number of hits on cached file info", time, time);
        this._countInfoHits = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countInfoMisses", "count", "Number of misses on cached file info", time, time);
        this._countInfoMisses = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countContentHits", "count", "Number of hits on cached file content", time, time);
        this._countContentHits = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countContentMisses", "", "Number of misses on cached file content", time, time);
        this._countContentMisses = new MutableCountStatisticImpl((CountStatistic)cs);
        this._startTime = time;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

