/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import com.sun.enterprise.ee.synchronization.cleaner.CleanerUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class FileHandler {
    private File _file = null;
    private File _trash = null;
    private static final long DEF_WAIT_PERIOD = 2000L;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager((Class)FileHandler.class);

    FileHandler(File file, File trash) {
        this._file = file;
        this._trash = trash;
    }

    void remove() throws IllegalAccessException, IOException {
        if (this._file == null || !this._file.exists()) {
            return;
        }
        if (CleanerUtils.isExcluded(this._file.getAbsolutePath())) {
            return;
        }
        long lModified = this._file.lastModified();
        long cTime = System.currentTimeMillis();
        if (cTime - lModified < 2000L) {
            return;
        }
        File tempFile = new File(this._trash, this._file.getName() + cTime);
        if (!this._file.renameTo(tempFile)) {
            String msg = _localStrMgr.getString("fileRenameError", (Object)this._file, (Object)tempFile);
            throw new IllegalAccessException(msg);
        }
        tempFile.deleteOnExit();
        _logger.log(Level.FINE, "synchronization.cleaner.file_removed", this._file.getPath());
    }
}

