/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import com.sun.enterprise.ee.synchronization.cleaner.CleanerUtils;
import com.sun.enterprise.ee.synchronization.cleaner.FileHandler;
import com.sun.enterprise.ee.synchronization.inventory.InventoryMgr;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class DirPruner
extends Thread {
    private File _root = null;
    private File _trash = null;
    private List _crList = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    DirPruner(File dir, File trash, List crList) {
        this._root = dir;
        this._trash = trash;
        this._crList = crList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void prune() {
        InventoryMgr mgr = null;
        if (this._root == null) return;
        if (!this._root.exists() || this._trash == null || this._crList == null) {
            return;
        }
        mgr = new InventoryMgr(this._root);
        if (this._crList.size() == 0) {
            _logger.log(Level.FINE, "Found empty inventory list from central repository for: " + this._root.getPath());
        }
        String[] cr = InventoryMgr.transformInventory(this._crList);
        List inventory = mgr.getInventory();
        Iterator iter = inventory.iterator();
        while (iter.hasNext()) {
            String f = (String)iter.next();
            if (!this.isACandidate(f, cr)) continue;
            File file = new File(this._root, f);
            FileHandler handler = new FileHandler(file, this._trash);
            handler.remove();
        }
        Object var9_9 = null;
        if (mgr == null) return;
        try {
            mgr.removeInventoryFile();
            mgr.removeGCTargetFile();
            return;
        }
        catch (Exception e) {}
        return;
        {
            catch (Exception exception) {
                Object var9_10 = null;
                if (mgr == null) return;
                try {
                    mgr.removeInventoryFile();
                    mgr.removeGCTargetFile();
                    return;
                }
                catch (Exception e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (mgr == null) throw throwable;
            try {
                mgr.removeInventoryFile();
                mgr.removeGCTargetFile();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void run() {
        this.prune();
    }

    private boolean isACandidate(String f, String[] cr) {
        boolean candidate = false;
        String file = FileUtils.makeForwardSlashes((String)f);
        if (CleanerUtils.isExcluded(file)) {
            return false;
        }
        if (Arrays.binarySearch(cr, file) < 0) {
            candidate = true;
            _logger.log(Level.FINE, "Found GC candidate: " + this._root.getPath() + File.separator + f);
        }
        return candidate;
    }
}

