/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.synchronization.JmxRequestMediator;
import com.sun.enterprise.ee.synchronization.ServerDirector;
import com.sun.enterprise.ee.synchronization.TextProcess;
import com.sun.enterprise.ee.synchronization.cleaner.Cleaner;
import com.sun.enterprise.ee.synchronization.cleaner.CleanerUtils;
import com.sun.enterprise.ee.synchronization.cleaner.CookieHandler;
import com.sun.enterprise.ee.synchronization.cleaner.DirPruner;
import com.sun.enterprise.ee.synchronization.cleaner.FileHandler;
import com.sun.enterprise.ee.synchronization.cleaner.TrashCleaner;
import com.sun.enterprise.ee.synchronization.store.FilePersistenceStore;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class CacheRepositoryCleaner
implements Cleaner {
    private ServerDirector _serverDirector = null;
    private String _serverName = null;
    private File _trash = null;
    private File _mainTrash = null;
    private File _applicationsDir = null;
    private File _generatedDir = null;
    private File _docrootDir = null;
    private File _libDir = null;
    private File _configDir = null;
    private static final String OPEN_PROP = "${";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private JmxRequestMediator[] _mediators = null;

    CacheRepositoryCleaner(ConfigContext ctx, String serverName, JmxRequestMediator[] mReqs) {
        this._serverDirector = new ServerDirector(ctx, serverName);
        this._serverName = serverName;
        this._mediators = mReqs;
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        this._mainTrash = CleanerUtils.getMainTrash();
        this._trash = CleanerUtils.getTemporaryTrash();
        this._applicationsDir = new File(instanceRoot + File.separator + "applications");
        this._generatedDir = new File(instanceRoot + File.separator + "generated");
        this._docrootDir = new File(instanceRoot + File.separator + "docroot");
        this._libDir = new File(instanceRoot + File.separator + "lib");
        this._configDir = new File(instanceRoot + File.separator + "config");
    }

    public void gc() {
        block12: {
            try {
                CookieHandler cHandler = new CookieHandler();
                if (!cHandler.isExpired()) break block12;
                try {
                    this.cleanApplications();
                }
                catch (Exception appEx) {
                    _logger.log(Level.FINE, "Application repository cleaner failed", appEx);
                }
                DirPruner[] pruners = CleanerUtils.getDirPruner(this._mediators, this._trash);
                try {
                    for (int i = 0; i < pruners.length; ++i) {
                        if (pruners[i] == null) continue;
                        pruners[i].start();
                    }
                }
                catch (Exception pruneEx) {
                    _logger.log(Level.FINE, "Error while pruning directory", pruneEx);
                }
                try {
                    this.removeSaveDirs();
                }
                catch (Exception saveEx) {
                    _logger.log(Level.FINE, "Error while cleaning trash", saveEx);
                }
                try {
                    for (int i = 0; i < pruners.length; ++i) {
                        if (pruners[i] == null) continue;
                        pruners[i].join();
                    }
                    this.cleanTrash();
                }
                catch (Exception trashEx) {
                    _logger.log(Level.FINE, "Error while cleaning trash", trashEx);
                }
                cHandler.updateCookie();
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Repository cleaner failed", e);
            }
        }
    }

    private void removeSaveDirs() {
        FilePersistenceStore store = new FilePersistenceStore();
        String applicationsSave = null;
        try {
            applicationsSave = (String)store.getBackupFileName(this._applicationsDir.getAbsolutePath());
            FileHandler handler = new FileHandler(new File(applicationsSave), this._trash);
            handler.remove();
        }
        catch (Exception applicationsEx) {
            try {
                FileUtils.liquidate((File)new File(applicationsSave));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Error while removing applications_save dir", e);
            }
        }
        String generatedSave = null;
        try {
            generatedSave = (String)store.getBackupFileName(this._generatedDir.getAbsolutePath());
            FileHandler handler = new FileHandler(new File(generatedSave), this._trash);
            handler.remove();
        }
        catch (Exception generatedEx) {
            try {
                FileUtils.liquidate((File)new File(generatedSave));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Error while removing generated_save dir", e);
            }
        }
        String docrootSave = null;
        try {
            docrootSave = (String)store.getBackupFileName(this._docrootDir.getAbsolutePath());
            FileHandler handler = new FileHandler(new File(docrootSave), this._trash);
            handler.remove();
        }
        catch (Exception docrootEx) {
            try {
                FileUtils.liquidate((File)new File(docrootSave));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Error while removing docroot_save dir", e);
            }
        }
        String libSave = null;
        try {
            libSave = (String)store.getBackupFileName(this._libDir.getAbsolutePath());
            FileHandler handler = new FileHandler(new File(libSave), this._trash);
            handler.remove();
        }
        catch (Exception libEx) {
            try {
                FileUtils.liquidate((File)new File(libSave));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Error while removing lib_save dir", e);
            }
        }
        String configSave = null;
        try {
            configSave = (String)store.getBackupFileName(this._configDir.getAbsolutePath());
            FileHandler handler = new FileHandler(new File(configSave), this._trash);
            handler.remove();
        }
        catch (Exception configEx) {
            try {
                FileUtils.liquidate((File)new File(configSave));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Error while removing config_save dir", e);
            }
        }
    }

    private void cleanTrash() {
        TrashCleaner tc = TrashCleaner.getInstance(this._mainTrash);
        tc.start();
    }

    private List getActiveAppList() {
        ArrayList<String> list = new ArrayList<String>();
        List applicationDirs = this._serverDirector.constructIncludes();
        Iterator iter = applicationDirs.iterator();
        while (iter.hasNext()) {
            String file = (String)iter.next();
            if (file == null || !file.startsWith("${com.sun.aas.instanceRoot")) continue;
            try {
                file = TextProcess.tokenizeConfig(file, this._serverName, new Properties());
                list.add(file);
            }
            catch (Exception e) {
                _logger.log(Level.INFO, "synchronization.cleaner.file_remove_error", file);
            }
        }
        return list;
    }

    private boolean isInList(List list, File dir) {
        boolean found = false;
        if (dir != null && list != null) {
            String target = dir.getAbsolutePath();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String file = (String)iter.next();
                String f = new File(file).getAbsolutePath();
                if (!target.equals(f)) continue;
                found = true;
                break;
            }
        }
        _logger.fine("Found target in associated application list " + dir.getPath() + " - " + found);
        return found;
    }

    private void cleanApplications() {
        this.cleanRemovedApplications();
    }

    private void cleanRemovedApplications() {
        List activeAppList = this.getActiveAppList();
        File apps_j2eeapps = new File(this._applicationsDir, "j2ee-apps");
        this.pruneRemovedApplicationsFromDir(activeAppList, apps_j2eeapps);
        File apps_j2eemodules = new File(this._applicationsDir, "j2ee-modules");
        this.pruneRemovedApplicationsFromDir(activeAppList, apps_j2eemodules);
        File apps_lifecyclemodules = new File(this._applicationsDir, "lifecycle-modules");
        this.pruneRemovedApplicationsFromDir(activeAppList, apps_lifecyclemodules);
        File gen_ejb_j2eeapps = new File(this._generatedDir, "ejb" + File.separator + "j2ee-apps");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_ejb_j2eeapps);
        File gen_ejb_j2eemodules = new File(this._generatedDir, "ejb" + File.separator + "j2ee-modules");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_ejb_j2eemodules);
        File gen_xml_j2eeapps = new File(this._generatedDir, "xml" + File.separator + "j2ee-apps");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_xml_j2eeapps);
        File gen_xml_j2eemodules = new File(this._generatedDir, "xml" + File.separator + "j2ee-modules");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_xml_j2eemodules);
        File gen_jsp_j2eeapps = new File(this._generatedDir, "jsp" + File.separator + "j2ee-apps");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_jsp_j2eeapps);
        File gen_jsp_j2eemodules = new File(this._generatedDir, "jsp" + File.separator + "j2ee-modules");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_jsp_j2eemodules);
        File gen_policy = new File(this._generatedDir, "policy");
        this.pruneRemovedApplicationsFromDir(activeAppList, gen_policy);
    }

    private void pruneRemovedApplicationsFromDir(List activeAppList, File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                _logger.fine("Inspecting file: " + files[i].getPath());
                if (!files[i].isDirectory() || this.isInList(activeAppList, files[i])) continue;
                try {
                    FileHandler handler = new FileHandler(files[i], this._trash);
                    handler.remove();
                    continue;
                }
                catch (Exception e) {
                    _logger.log(Level.INFO, "synchronization.cleaner.file_remove_error", files[i].getPath());
                }
            }
        }
    }

    private void cleanUnassociatedApplications() {
        List applicationDirs = this._serverDirector.constructExcludes();
        Iterator iter = applicationDirs.iterator();
        while (iter.hasNext()) {
            String file = (String)iter.next();
            if (file == null || !file.startsWith("${com.sun.aas.instanceRoot")) continue;
            try {
                file = TextProcess.tokenizeConfig(file, this._serverName, new Properties());
                File f = new File(file);
                FileHandler handler = new FileHandler(f, this._trash);
                handler.remove();
            }
            catch (Exception e) {
                _logger.log(Level.INFO, "synchronization.cleaner.file_remove_error", file);
            }
        }
    }
}

