/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.audit;

import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.inventory.InventoryMgr;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

class RequestAuditor {
    private SynchronizationResponse _response = null;
    private List _missingList = null;
    private List _extraList = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private static final StringManager _localStrMgr = StringManager.getManager((Class)RequestAuditor.class);

    RequestAuditor(SynchronizationResponse response) {
        this._response = response;
    }

    void audit() {
        SynchronizationRequest[] requests = this._response.getReply();
        List local = this.getLocalInventory();
        List central = this._response.getFileList();
        this._missingList = InventoryMgr.getInventoryDiff(central, local);
        this._extraList = InventoryMgr.getInventoryDiff(local, central);
    }

    List getMissingList() {
        return this._missingList;
    }

    List getExtraList() {
        return this._extraList;
    }

    private List getLocalInventory() {
        SynchronizationRequest[] requests = this._response.getReply();
        ArrayList<String> localList = new ArrayList<String>();
        for (int i = 0; i < requests.length; ++i) {
            File f = requests[i].getFile();
            String tDir = requests[i].getTargetDirectory();
            if (f.isDirectory()) {
                InventoryMgr mgr;
                List l;
                String dir = requests[i].getBaseDirectory() + File.separator + tDir;
                _logger.fine("Inspecting Directory: " + dir);
                File root = new File(dir);
                if (!root.isDirectory() || (l = (mgr = new InventoryMgr(root)).getInventory()) == null) continue;
                int length = l.size();
                for (int j = 0; j < length; ++j) {
                    localList.add(tDir + File.separator + l.get(j));
                }
                continue;
            }
            if (!f.isFile()) continue;
            localList.add(tDir + File.separator + f.getName());
        }
        return localList;
    }
}

