/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.proxy.MBeanServerProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationMBean;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

class PingCommand
implements Command {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private Object _response = null;
    private DASPropertyReader _dasInfo = null;
    private static final int MAX_RETRY = 3;
    private static final String NAME = "Synchronization-Ping-Command";
    private static final String MBEAN_NAME = "com.sun.appserv:type=synchronization,category=config";
    private static final long DEFAULT_RETRY_INTV = 3000L;
    private static final String SERVER_NAME = System.getProperty("com.sun.aas.instanceName");
    private static final String SYNC_NO_CONNECTION = "synchronization.no_connection";

    PingCommand(DASPropertyReader dpr) {
        this._dasInfo = dpr;
    }

    public void execute() {
        try {
            MBeanServerConnectionInfo connInfo = new MBeanServerConnectionInfo(this._dasInfo);
            for (int count = 0; count < 3; ++count) {
                try {
                    SynchronizationMBean proxy = (SynchronizationMBean)MBeanServerProxy.getMBeanServerProxy(SynchronizationMBean.class, new ObjectName(MBEAN_NAME), connInfo);
                    this._response = proxy.ping(SERVER_NAME);
                    break;
                }
                catch (Exception e) {
                    this._response = this.getReal(e);
                    _logger.log(Level.FINE, _strMgr.getString(SYNC_NO_CONNECTION, (Object)this._dasInfo.getJMXURL()));
                    Thread.currentThread();
                    Thread.sleep(3000L);
                    continue;
                }
            }
        }
        catch (Exception e) {
            this._response = e;
            _logger.log(Level.FINE, _strMgr.getString(SYNC_NO_CONNECTION, (Object)this._dasInfo.getJMXURL()));
        }
    }

    public String getName() {
        return NAME;
    }

    boolean isAlive() {
        return !(this._response instanceof Exception);
    }

    public Object getResult() {
        return this._response;
    }

    private Throwable getReal(Exception e) {
        Throwable real = null;
        real = this.exceptionHierarchyIsExpected(e) ? e.getCause().getCause() : e;
        return real;
    }

    private boolean exceptionHierarchyIsExpected(Throwable t) {
        Throwable at;
        boolean expected = false;
        if (t instanceof UndeclaredThrowableException && (at = t.getCause()) instanceof AgentException && (at = at.getCause()) != null) {
            expected = true;
        }
        return expected;
    }
}

