/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.JmxRequestMediator;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.cleaner.GroupRequestCleaner;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmxGroupRequestMediator
implements Runnable {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _logStrMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private JmxRequestMediator[] _mediators = null;
    private Exception _exception = null;
    private boolean _isException = false;
    private Transaction _tx = null;

    public JmxGroupRequestMediator(DASPropertyReader p, SynchronizationRequest[] reqs, Transaction tx) {
        this._tx = tx;
        this._mediators = new JmxRequestMediator[reqs.length];
        for (int i = 0; i < reqs.length; ++i) {
            this._mediators[i] = new JmxRequestMediator(p, reqs[i], tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                for (int i = 0; i < this._mediators.length; ++i) {
                    this._mediators[i].execute();
                }
                this._tx.voteCommit();
                _logger.log(Level.FINE, _logStrMgr.getString("synchronization.vote_commit"));
            }
            catch (Exception e) {
                this._tx.voteRollback();
                _logger.log(Level.FINE, _logStrMgr.getString("synchronization.vote_rollback"));
                this._exception = e;
                this._isException = true;
                Object var3_4 = null;
                int i = 0;
                while (true) {
                    if (i >= this._mediators.length) {
                        _logger.log(Level.FINE, _logStrMgr.getString("synchronization.tran_commit"));
                        if (!this._tx.isCommited()) return;
                        GroupRequestCleaner ac = new GroupRequestCleaner(this._mediators);
                        ac.gc();
                        return;
                    }
                    this._mediators[i].commit();
                    ++i;
                }
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            int i = 0;
            while (true) {
                if (i >= this._mediators.length) {
                    _logger.log(Level.FINE, _logStrMgr.getString("synchronization.tran_commit"));
                    if (!this._tx.isCommited()) throw throwable;
                    GroupRequestCleaner ac = new GroupRequestCleaner(this._mediators);
                    ac.gc();
                    throw throwable;
                }
                this._mediators[i].commit();
                ++i;
            }
        }
        for (int i = 0; i < this._mediators.length; ++i) {
            this._mediators[i].commit();
        }
        _logger.log(Level.FINE, _logStrMgr.getString("synchronization.tran_commit"));
        if (!this._tx.isCommited()) return;
        GroupRequestCleaner ac = new GroupRequestCleaner(this._mediators);
        ac.gc();
    }

    public boolean isException() {
        return this._isException;
    }

    public Exception getException() {
        return this._exception;
    }
}

