/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.security;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.ee.security.NssStore;
import com.sun.enterprise.ee.security.NssTokenInfo;
import com.sun.enterprise.ee.synchronization.api.SecurityServiceMgr;
import com.sun.enterprise.ee.synchronization.api.SynchronizationContext;
import com.sun.enterprise.ee.synchronization.api.SynchronizationFactory;
import com.sun.enterprise.security.SecuritySupportImpl;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.OS;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EESecuritySupportImpl
extends SecuritySupportImpl {
    private static Logger _logger;
    private static final String INTERNAL_TOKEN = "NSS Certificate DB";
    private static final String NAME_PREFIX = "__SUN_SJSAS_";

    public EESecuritySupportImpl() {
        super(false);
    }

    public void synchronizeKeyFile(ConfigContext configContext, String fileRealmName) throws Exception {
        if (AdminService.getAdminService().isDas()) {
            return;
        }
        SynchronizationContext synchCtx = SynchronizationFactory.createSynchronizationContext(configContext);
        SecurityServiceMgr securitySynchMgr = synchCtx.getSecurityServiceMgr();
        securitySynchMgr.synchronizeKeyFile(fileRealmName);
    }

    private static void loadSunPKCS11Stores(Constructor fileConstructor, Constructor streamConstructor, String dbDir, String libsoftokenLib, List tokenInfoList, Map name2PwdMap) throws Exception {
        Map token2ConfigMap = EESecuritySupportImpl.getOtherConfigMap();
        tokenInfoList.add(new NssTokenInfo(INTERNAL_TOKEN, libsoftokenLib, 1));
        int size = tokenInfoList.size();
        for (int i = 0; i < size; ++i) {
            NssTokenInfo tokenInfo = (NssTokenInfo)tokenInfoList.get(i);
            String tokenName = tokenInfo.getTokenName();
            String configFile = (String)token2ConfigMap.get(tokenName);
            Provider pkcs11Provider = null;
            if (configFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Load PKCS11 stores with " + configFile);
                }
                pkcs11Provider = (Provider)fileConstructor.newInstance(configFile);
            } else {
                InputStream configStream = null;
                if (INTERNAL_TOKEN.equals(tokenName)) {
                    configStream = EESecuritySupportImpl.getNSSPKCS11ConfigStream(dbDir, libsoftokenLib);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Load NSS PKCS11 stores with dbDir = " + dbDir + ", softoken lib = " + libsoftokenLib);
                    }
                } else {
                    String libname = tokenInfo.getLibname();
                    int slotListIndex = tokenInfo.getSlotListIndex();
                    configStream = EESecuritySupportImpl.getPKCS11ConfigStream(NAME_PREFIX + i, libname, slotListIndex);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Load PKCS11 stores with tokenName = " + tokenName + ", libname = " + libname + ", slotListIndex = " + slotListIndex);
                    }
                }
                pkcs11Provider = (Provider)streamConstructor.newInstance(tokenName, configStream);
            }
            Security.insertProviderAt(pkcs11Provider, i + 1);
            String password = (String)name2PwdMap.get(tokenName);
            if (INTERNAL_TOKEN.equals(tokenName) || password == null) {
                password = NssStore.getNssDbPassword();
            }
            EESecuritySupportImpl.loadStores((String)tokenName, (String)"PKCS11", (Provider)pkcs11Provider, null, (String)password, null, (String)password);
        }
    }

    private static Map getOtherConfigMap() throws ConfigException {
        LinkedHashMap<String, String> token2ConfigMap = new LinkedHashMap<String, String>();
        ServerContext serverContext = ApplicationServer.getServerContext();
        ElementProperty[] elementProps = null;
        if (serverContext != null) {
            SecurityService securityService;
            ConfigContext configContext = serverContext.getConfigContext();
            if (configContext != null && (securityService = ServerBeansFactory.getSecurityServiceBean((ConfigContext)configContext)) != null) {
                elementProps = securityService.getElementProperty();
            }
        } else {
            NodeAgent nodeAgent;
            NodeAgents nodeAgents;
            Domain domain;
            String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + "/config/domain.xml";
            ConfigContext configContext = ConfigFactory.createConfigContext((String)domainXMLLocation);
            if (configContext != null && (domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext)) != null && (nodeAgents = domain.getNodeAgents()) != null && (nodeAgent = nodeAgents.getNodeAgentByName(System.getProperty("com.sun.aas.instanceName"))) != null) {
                elementProps = nodeAgent.getElementProperty();
            }
        }
        if (elementProps != null && elementProps.length > 0) {
            for (int i = 0; i < elementProps.length; ++i) {
                token2ConfigMap.put(elementProps[i].getName(), elementProps[i].getValue());
            }
        }
        return token2ConfigMap;
    }

    private static InputStream getNSSPKCS11ConfigStream(String dbDir, String library) {
        StringBuffer buf = new StringBuffer("name=__SUN_SJSAS_internal\n");
        buf.append("library=").append(library).append("\n");
        buf.append("nssArgs=\"configdir='").append(dbDir).append("' certPrefix='' keyPrefix='' secmod='secmod.db'\"\n");
        buf.append("slot=2\n");
        buf.append("attributes=compatibility\n");
        buf.append("omitInitialize=true\n");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    private static InputStream getPKCS11ConfigStream(String name, String library, int slotListIndex) {
        StringBuffer buf = new StringBuffer("name=").append(name).append("\n");
        buf.append("library=").append(library).append("\n");
        buf.append("slotListIndex=").append(slotListIndex).append("\n");
        buf.append("omitInitialize=true\n");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    static {
        Constructor<?> streamConstructor;
        Constructor<?> fileConstructor;
        String libsoftokenLib;
        String dbDir;
        block18: {
            _logger = null;
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
            boolean isWin = OS.isWindows();
            if (!isWin) {
                System.loadLibrary("nspr4");
            } else {
                System.loadLibrary("libnspr4");
            }
            dbDir = System.getProperty("com.sun.appserv.nss.db");
            if (System.getProperty("os.name") == "HP-UX") {
                libsoftokenLib = System.getProperty("com.sun.aas.nssRoot") + File.separator + (isWin ? "softoken.dll" : "libsoftokn3.sl");
                System.setProperty("com.sun.aas.instanceRoot.softokenLib", libsoftokenLib);
            } else {
                libsoftokenLib = System.getProperty("com.sun.aas.nssRoot") + File.separator + (isWin ? "softoken3.dll" : "libsoftokn3.so");
                System.setProperty("com.sun.aas.instanceRoot.softokenLib", libsoftokenLib);
            }
            fileConstructor = null;
            streamConstructor = null;
            File softTokenFile = new File(libsoftokenLib);
            if (softTokenFile.exists()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Softtoken library exists.");
                }
                if (!isWin) {
                    System.loadLibrary("plc4");
                    System.loadLibrary("plds4");
                } else {
                    System.loadLibrary("libplc4");
                    System.loadLibrary("libplds4");
                }
                try {
                    Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
                    fileConstructor = clazz.getDeclaredConstructor(String.class);
                    streamConstructor = clazz.getDeclaredConstructor(String.class, InputStream.class);
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block18;
                    _logger.log(Level.FINE, "Cannot construct SunPKCS11: " + ex);
                }
            }
        }
        Map name2PwdMap = IdentityManager.getMap();
        if (fileConstructor != null && streamConstructor != null) {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Using SunPKCS11 ...");
                }
                NssStore nssStore = NssStore.getInstance(null, false);
                List tokenInfoList = nssStore.getTokenInfoList();
                EESecuritySupportImpl.loadSunPKCS11Stores(fileConstructor, streamConstructor, dbDir, libsoftokenLib, tokenInfoList, name2PwdMap);
                nssStore.initCAStore(NssStore.getNssDbPassword());
                trustStores.add((KeyStore)nssStore.getTrustStores().get(0));
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "nss.init_SunPKCS11_failed", ex);
                throw new IllegalStateException(ex.getMessage());
            }
        }
        try {
            NssStore nssStore = NssStore.getInstance();
            tokenNames = nssStore.getTokenNames();
            keyStorePasswords.add(NssStore.getNssDbPassword());
            for (int i = 0; i < tokenNames.size(); ++i) {
                String tName = (String)tokenNames.get(i);
                keyStorePasswords.add((String)name2PwdMap.get(tName));
            }
            keyStores = nssStore.getKeyStores();
            trustStores = nssStore.getTrustStores();
            tokenNames.add(INTERNAL_TOKEN);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "NSS calls fail.", ex);
            }
            throw new IllegalStateException(ex.getMessage());
        }
    }
}

